/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.storage.UpProgressBytesHandler;
import com.qiniu.android.storage.UpProgressHandler;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.LogUtil;

class UpProgress {
    private long maxProgressUploadBytes = -1L;
    private long previousUploadBytes = 0L;
    private final UpProgressHandler handler;

    UpProgress(UpProgressHandler handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progress(String key, long uploadBytes, long totalBytes) {
        UpProgress upProgress;
        if (this.handler == null || uploadBytes < 0L || totalBytes > 0L && uploadBytes > totalBytes) {
            return;
        }
        if (totalBytes > 0L) {
            upProgress = this;
            synchronized (upProgress) {
                if (this.maxProgressUploadBytes < 0L) {
                    this.maxProgressUploadBytes = (long)((double)totalBytes * 0.95);
                }
            }
            if (uploadBytes > this.maxProgressUploadBytes) {
                return;
            }
        }
        upProgress = this;
        synchronized (upProgress) {
            if (uploadBytes <= this.previousUploadBytes) {
                return;
            }
            this.previousUploadBytes = uploadBytes;
        }
        this.notify(key, uploadBytes, totalBytes);
    }

    public void notifyDone(String key, long totalBytes) {
        this.notify(key, totalBytes, totalBytes);
    }

    private void notify(final String key, final long uploadBytes, final long totalBytes) {
        if (this.handler == null) {
            return;
        }
        if (this.handler instanceof UpProgressBytesHandler) {
            AsyncRun.runInMain(new Runnable(){
                final /* synthetic */ UpProgress this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    LogUtil.i("key:" + key + " progress uploadBytes:" + uploadBytes + " totalBytes:" + totalBytes);
                    ((UpProgressBytesHandler)this.this$0.handler).progress(key, uploadBytes, totalBytes);
                }
            });
            return;
        }
        if (totalBytes <= 0L) {
            return;
        }
        final double notifyPercent = (double)uploadBytes / (double)totalBytes;
        AsyncRun.runInMain(new Runnable(){
            final /* synthetic */ UpProgress this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                LogUtil.i("key:" + key + " progress:" + notifyPercent);
                this.this$0.handler.progress(key, notifyPercent);
            }
        });
    }
}

