/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.PartsUploadPerformer;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadData;
import com.qiniu.android.storage.UploadInfo;
import com.qiniu.android.storage.UploadInfoV2;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.storage.UploadSource;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class PartsUploadPerformerV2
extends PartsUploadPerformer {
    PartsUploadPerformerV2(UploadSource uploadSource, String fileName, String key, UpToken token, UploadOptions options, Configuration config, String recorderKey) {
        super(uploadSource, fileName, key, token, options, config, recorderKey);
    }

    @Override
    UploadInfo getUploadInfoFromJson(UploadSource source, JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return UploadInfoV2.infoFromJson(source, jsonObject);
    }

    @Override
    UploadInfo getDefaultUploadInfo() {
        return new UploadInfoV2(this.uploadSource, this.config);
    }

    @Override
    void serverInit(final PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandler) {
        final UploadInfoV2 info = (UploadInfoV2)this.uploadInfo;
        if (info != null && info.isValid()) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " serverInit success");
            ResponseInfo responseInfo = ResponseInfo.successResponse();
            completeHandler.complete(responseInfo, null, null);
            return;
        }
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.initPart(true, new RequestTransaction.RequestCompleteHandler(){
            final /* synthetic */ PartsUploadPerformerV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                this.this$0.destroyUploadRequestTransaction(transaction);
                String uploadId = null;
                Long expireAt = null;
                if (response != null) {
                    try {
                        uploadId = response.getString("uploadId");
                        expireAt = response.getLong("expireAt");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (responseInfo.isOK() && uploadId != null && expireAt != null) {
                    info.uploadId = uploadId;
                    info.expireAt = expireAt;
                    this.this$0.recordUploadInfo();
                }
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void uploadNextData(final PartsUploadPerformer.PartsUploadPerformerDataCompleteHandler completeHandler) {
        UploadInfoV2 info = (UploadInfoV2)this.uploadInfo;
        UploadData data = null;
        UploadSource uploadSource = this.uploadSource;
        synchronized (uploadSource) {
            try {
                data = info.nextUploadData();
                if (data != null) {
                    data.updateState(UploadData.State.Uploading);
                }
            }
            catch (Exception e) {
                LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " " + e.getMessage());
                ResponseInfo responseInfo = ResponseInfo.localIOError(e.getMessage());
                completeHandler.complete(true, responseInfo, null, responseInfo.response);
                return;
            }
        }
        if (data == null) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " no data left");
            ResponseInfo responseInfo = null;
            responseInfo = this.uploadInfo.getSourceSize() == 0L ? ResponseInfo.zeroSize("file is empty") : ResponseInfo.sdkInteriorError("no chunk left");
            completeHandler.complete(true, responseInfo, null, null);
            return;
        }
        final UploadData uploadData = data;
        RequestProgressHandler progressHandler = new RequestProgressHandler(){
            final /* synthetic */ PartsUploadPerformerV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void progress(long totalBytesWritten, long totalBytesExpectedToWrite) {
                uploadData.setUploadSize(totalBytesWritten);
                this.this$0.notifyProgress(false);
            }
        };
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.uploadPart(true, info.uploadId, info.getPartIndexOfData(data), data.data, progressHandler, new RequestTransaction.RequestCompleteHandler(){
            final /* synthetic */ PartsUploadPerformerV2 this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                this.this$0.destroyUploadRequestTransaction(transaction);
                String etag = null;
                String md5 = null;
                if (response != null) {
                    try {
                        etag = response.getString("etag");
                        md5 = response.getString("md5");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (responseInfo.isOK() && etag != null && md5 != null) {
                    UploadSource uploadSource = this.this$0.uploadSource;
                    synchronized (uploadSource) {
                        uploadData.etag = etag;
                        uploadData.updateState(UploadData.State.Complete);
                    }
                    this.this$0.recordUploadInfo();
                    this.this$0.notifyProgress(false);
                } else {
                    UploadSource uploadSource = this.this$0.uploadSource;
                    synchronized (uploadSource) {
                        uploadData.updateState(UploadData.State.WaitToUpload);
                    }
                }
                completeHandler.complete(false, responseInfo, requestMetrics, response);
            }
        });
    }

    @Override
    void completeUpload(final PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandler) {
        UploadInfoV2 info = (UploadInfoV2)this.uploadInfo;
        List<Map<String, Object>> partInfoArray = info.getPartInfoArray();
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.completeParts(true, this.fileName, info.uploadId, partInfoArray, new RequestTransaction.RequestCompleteHandler(){
            final /* synthetic */ PartsUploadPerformerV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                if (responseInfo.isOK()) {
                    this.this$0.notifyProgress(true);
                }
                this.this$0.destroyUploadRequestTransaction(transaction);
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }
}

