/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import android.content.Context;
import com.qiniu.android.http.dns.Dns;
import com.qiniu.android.utils.UrlSafeBase64;
import com.qiniu.android.utils.Utils;
import org.json.JSONArray;

public class GlobalConfiguration {
    public static Context appContext;
    public boolean isDnsOpen = true;
    public int dnsRepreHostNum = 2;
    public int dnsResolveTimeout = 3;
    public int dnsCacheTime = 120;
    public int dnsCacheMaxTTL = 600;
    public Dns dns = null;
    public String dnsCacheDir = Utils.sdkDirectory() + "/dnsCache/";
    public boolean udpDnsEnable = true;
    public static String[] DefaultUdpDnsIpv4Servers;
    public String[] udpDnsIpv4Servers = null;
    public static String[] DefaultUdpDnsIpv6Servers;
    public String[] udpDnsIpv6Servers = null;
    public boolean dohEnable = true;
    public static String[] DefaultDohIpv4Servers;
    public String[] dohIpv4Servers = null;
    public static String[] DefaultDohIpv6Servers;
    public String[] dohIpv6Servers = null;
    public int globalHostFrozenTime = 10;
    public int partialHostFrozenTime = 300;
    public static String[] DefaultConnectCheckURLStrings;
    public String[] connectCheckURLStrings = null;
    public int connectCheckTimeout = 2;
    public boolean connectCheckEnable = true;
    public boolean enableHttp3 = false;
    private static final GlobalConfiguration configuration;

    private GlobalConfiguration() {
    }

    public static GlobalConfiguration getInstance() {
        return configuration;
    }

    public String[] getUdpDnsIpv4Servers() {
        if (this.udpDnsIpv4Servers != null) {
            return this.udpDnsIpv4Servers;
        }
        return DefaultUdpDnsIpv4Servers;
    }

    public String[] getUdpDnsIpv6Servers() {
        if (this.udpDnsIpv6Servers != null) {
            return this.udpDnsIpv6Servers;
        }
        return DefaultUdpDnsIpv6Servers;
    }

    public String[] getDohIpv4Servers() {
        if (this.dohIpv4Servers != null) {
            return this.dohIpv4Servers;
        }
        return DefaultDohIpv4Servers;
    }

    public String[] getDohIpv6Servers() {
        if (this.dohIpv6Servers != null) {
            return this.dohIpv6Servers;
        }
        return DefaultDohIpv6Servers;
    }

    public String[] getConnectCheckUrls() {
        if (this.connectCheckURLStrings != null) {
            return this.connectCheckURLStrings;
        }
        return DefaultConnectCheckURLStrings;
    }

    public static String[] parseBase64Array(String data) {
        try {
            byte[] jsonBytes = UrlSafeBase64.decode(data);
            JSONArray jsonArray = new JSONArray(new String(jsonBytes));
            int count = jsonArray.length();
            String[] items = new String[count];
            for (int i = 0; i < count; ++i) {
                items[i] = jsonArray.getString(i);
            }
            return items;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        DefaultUdpDnsIpv4Servers = GlobalConfiguration.parseBase64Array("WyIyMjMuNS41LjUiLCAiMTE0LjExNC4xMTQuMTE0IiwgIjEuMS4xLjEiLCAiOC44LjguOCJd");
        DefaultUdpDnsIpv6Servers = null;
        DefaultDohIpv4Servers = GlobalConfiguration.parseBase64Array("WyJodHRwczovLzIyMy42LjYuNi9kbnMtcXVlcnkiLCAiaHR0cHM6Ly84LjguOC44L2Rucy1xdWVyeSJd");
        DefaultDohIpv6Servers = null;
        DefaultConnectCheckURLStrings = GlobalConfiguration.parseBase64Array("WyJodHRwczovL3d3dy5xaW5pdS5jb20iLCAiaHR0cHM6Ly93d3cuYmFpZHUuY29tIiwgImh0dHBzOi8vd3d3Lmdvb2dsZS5jb20iXQ==");
        configuration = new GlobalConfiguration();
    }
}

