/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.request;

import android.util.Log;
import com.qiniu.android.collect.ReportItem;
import com.qiniu.android.collect.UploadInfoReporter;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.connectCheck.ConnectChecker;
import com.qiniu.android.http.dns.DnsPrefetcher;
import com.qiniu.android.http.dns.DnsSource;
import com.qiniu.android.http.metrics.UploadSingleRequestMetrics;
import com.qiniu.android.http.networkStatus.NetworkStatusManager;
import com.qiniu.android.http.request.IRequestClient;
import com.qiniu.android.http.request.IUploadServer;
import com.qiniu.android.http.request.Request;
import com.qiniu.android.http.request.UploadRequestInfo;
import com.qiniu.android.http.request.UploadRequestState;
import com.qiniu.android.http.request.handler.CheckCancelHandler;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.http.request.handler.RequestShouldRetryHandler;
import com.qiniu.android.http.request.httpclient.SystemHttpClient;
import com.qiniu.android.http.serverRegion.HttpServerManager;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.GlobalConfiguration;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.Utils;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONObject;

class HttpSingleRequest {
    private int currentRetryTime;
    private final Configuration config;
    private final UploadOptions uploadOption;
    private final UpToken token;
    private final UploadRequestInfo requestInfo;
    private final UploadRequestState requestState;
    private ArrayList<UploadSingleRequestMetrics> requestMetricsList;
    private IRequestClient client;

    HttpSingleRequest(Configuration config, UploadOptions uploadOption, UpToken token, UploadRequestInfo requestInfo, UploadRequestState requestState) {
        this.config = config;
        this.uploadOption = uploadOption;
        this.token = token;
        this.requestInfo = requestInfo;
        this.requestState = requestState;
        this.currentRetryTime = 0;
    }

    void request(Request request, IUploadServer server, boolean isAsync, RequestShouldRetryHandler shouldRetryHandler, RequestProgressHandler progressHandler, RequestCompleteHandler completeHandler) {
        this.currentRetryTime = 0;
        this.requestMetricsList = new ArrayList();
        this.retryRequest(request, server, isAsync, shouldRetryHandler, progressHandler, completeHandler);
    }

    private void retryRequest(final Request request, final IUploadServer server, final boolean isAsync, final RequestShouldRetryHandler shouldRetryHandler, final RequestProgressHandler progressHandler, final RequestCompleteHandler completeHandler) {
        this.client = this.config.requestClient != null && (!this.config.requestClient.getClientId().equals("qn-curl") || server != null && server.isHttp3()) ? this.config.requestClient : new SystemHttpClient();
        final CheckCancelHandler checkCancelHandler = new CheckCancelHandler(){

            @Override
            public boolean checkCancel() {
                boolean isCancelled = HttpSingleRequest.this.requestState.isUserCancel();
                if (!isCancelled && HttpSingleRequest.this.uploadOption != null && ((HttpSingleRequest)HttpSingleRequest.this).uploadOption.cancellationSignal != null) {
                    isCancelled = ((HttpSingleRequest)HttpSingleRequest.this).uploadOption.cancellationSignal.isCancelled();
                }
                return isCancelled;
            }
        };
        LogUtil.i("key:" + StringUtils.toNonnullString(this.requestInfo.key) + " retry:" + this.currentRetryTime + " url:" + StringUtils.toNonnullString(request.urlString) + " ip:" + StringUtils.toNonnullString(server.getIp()));
        this.client.request(request, new IRequestClient.Options(server, isAsync, this.config.proxy), new IRequestClient.Progress(){
            final /* synthetic */ HttpSingleRequest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void progress(long totalBytesWritten, long totalBytesExpectedToWrite) {
                if (checkCancelHandler.checkCancel()) {
                    this.this$0.requestState.setUserCancel(true);
                    if (this.this$0.client != null) {
                        this.this$0.client.cancel();
                    }
                } else if (progressHandler != null) {
                    progressHandler.progress(totalBytesWritten, totalBytesExpectedToWrite);
                }
            }
        }, new IRequestClient.CompleteHandler(){
            final /* synthetic */ HttpSingleRequest this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void complete(ResponseInfo responseInfo, UploadSingleRequestMetrics metrics, JSONObject response) {
                boolean hijacked;
                this.this$0.updateHttpServerInfo(server, responseInfo);
                if (metrics != null) {
                    this.this$0.requestMetricsList.add(metrics);
                }
                if (checkCancelHandler.checkCancel()) {
                    responseInfo = ResponseInfo.cancelled();
                    this.this$0.reportRequest(responseInfo, server, metrics);
                    this.this$0.completeAction(server, responseInfo, responseInfo.response, metrics, completeHandler);
                    return;
                }
                if (responseInfo != null) {
                    responseInfo = responseInfo.checkMaliciousResponse();
                }
                boolean isSafeDnsSource = DnsSource.isCustom(server.getSource()) || DnsSource.isDoh(server.getSource()) || DnsSource.isDnspod(server.getSource());
                boolean bl = hijacked = responseInfo != null && responseInfo.isNotQiniu() && !isSafeDnsSource;
                if (hijacked && metrics != null) {
                    metrics.setHijacked("forsure");
                    try {
                        metrics.setSyncDnsSource(DnsPrefetcher.getInstance().lookupBySafeDns(server.getHost()));
                    }
                    catch (Exception e) {
                        metrics.setSyncDnsError(e.toString());
                    }
                }
                if (!hijacked && this.this$0.shouldCheckConnect(responseInfo)) {
                    UploadSingleRequestMetrics checkMetrics = ConnectChecker.check();
                    if (metrics != null) {
                        metrics.setConnectCheckMetrics(checkMetrics);
                    }
                    if (!ConnectChecker.isConnected(checkMetrics)) {
                        String message = responseInfo == null ? "" : "check origin statusCode:" + responseInfo.statusCode + " error:" + responseInfo.error;
                        responseInfo = ResponseInfo.errorInfo(-1009, message);
                    } else if (metrics != null && !isSafeDnsSource) {
                        metrics.setHijacked("maybe");
                        try {
                            metrics.setSyncDnsSource(DnsPrefetcher.getInstance().lookupBySafeDns(server.getHost()));
                        }
                        catch (Exception e) {
                            metrics.setSyncDnsError(e.toString());
                        }
                    }
                }
                this.this$0.reportRequest(responseInfo, server, metrics);
                LogUtil.i("key:" + StringUtils.toNonnullString(((HttpSingleRequest)this.this$0).requestInfo.key) + " response:" + StringUtils.toNonnullString(responseInfo));
                if (shouldRetryHandler != null && shouldRetryHandler.shouldRetry(responseInfo, response) && this.this$0.currentRetryTime < ((HttpSingleRequest)this.this$0).config.retryMax && responseInfo != null && responseInfo.couldHostRetry()) {
                    this.this$0.currentRetryTime += 1;
                    try {
                        Thread.sleep(((HttpSingleRequest)this.this$0).config.retryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.this$0.retryRequest(request, server, isAsync, shouldRetryHandler, progressHandler, completeHandler);
                } else {
                    this.this$0.completeAction(server, responseInfo, response, metrics, completeHandler);
                }
            }
        });
    }

    private boolean shouldCheckConnect(ResponseInfo responseInfo) {
        GlobalConfiguration cfg = GlobalConfiguration.getInstance();
        String[] checkUrls = cfg.getConnectCheckUrls();
        if (!cfg.connectCheckEnable && checkUrls == null || checkUrls.length == 0) {
            return false;
        }
        return responseInfo != null && (responseInfo.statusCode == -1 || responseInfo.statusCode == -1001 || responseInfo.statusCode == -1003 || responseInfo.statusCode == -1004 || responseInfo.statusCode == -1005 || responseInfo.statusCode == -1009 || responseInfo.isTlsError());
    }

    private synchronized void completeAction(IUploadServer server, ResponseInfo responseInfo, JSONObject response, UploadSingleRequestMetrics requestMetrics, RequestCompleteHandler completeHandler) {
        if (this.client == null) {
            return;
        }
        this.client = null;
        this.updateHostNetworkStatus(responseInfo, server, requestMetrics);
        if (completeHandler != null) {
            completeHandler.complete(responseInfo, this.requestMetricsList, response);
        }
    }

    private void updateHostNetworkStatus(ResponseInfo responseInfo, IUploadServer server, UploadSingleRequestMetrics requestMetrics) {
        if (requestMetrics == null) {
            return;
        }
        long byteCount = requestMetrics.bytesSend();
        long milliSecond = requestMetrics.totalElapsedTime();
        if (milliSecond <= 0L || byteCount < 1024L) {
            return;
        }
        if (byteCount <= 8192L) {
            milliSecond = (long)((double)milliSecond * 0.08);
        } else if (byteCount <= 16384L) {
            milliSecond = (long)((double)milliSecond * 0.15);
        } else if (byteCount <= 32768L) {
            milliSecond = (long)((double)milliSecond * 0.22);
        } else if (byteCount <= 65536L) {
            milliSecond = (long)((double)milliSecond * 0.3);
        } else if (byteCount <= 131072L) {
            milliSecond = (long)((double)milliSecond * 0.45);
        } else if (byteCount <= 262144L) {
            milliSecond = (long)((double)milliSecond * 0.76);
        } else if (byteCount <= 524288L) {
            milliSecond = (long)((double)milliSecond * 0.88);
        } else if (byteCount <= 0x100000L) {
            milliSecond = (long)((double)milliSecond * 0.95);
        }
        if (milliSecond <= 0L) {
            milliSecond = 10L;
        }
        int speed = (int)(byteCount / milliSecond);
        Log.d((String)"speed", (String)("httpVersion:" + server.getHttpVersion() + " byte:" + (double)byteCount / 1024.0 + "  milliSecond:" + milliSecond + "   speed:" + speed));
        String type = NetworkStatusManager.getNetworkStatusType(server.getHttpVersion(), server.getHost(), server.getIp());
        NetworkStatusManager.getInstance().updateNetworkStatus(type, speed);
    }

    private void updateHttpServerInfo(IUploadServer server, ResponseInfo responseInfo) {
        String[] items;
        if (responseInfo == null || responseInfo.responseHeader == null || server == null || server.getHost() == null) {
            return;
        }
        String altSvc = responseInfo.responseHeader.get("x-alt-svc");
        if (altSvc == null) {
            return;
        }
        int live = 0;
        String ip = null;
        String host = server.getHost();
        for (String it : items = altSvc.split(";")) {
            String[] maItems;
            String item = it.replace(" ", "");
            if ((item = item.replace("\"", "")).contains("ip=")) {
                String[] ipItems = item.split("=");
                if (ipItems.length != 2 || !ipItems[0].equals("ip")) continue;
                ip = ipItems[1];
                continue;
            }
            if (!item.contains("ma=") || (maItems = item.split("=")).length != 2 || !maItems[0].equals("ma")) continue;
            live = Integer.parseInt(maItems[1]);
        }
        if (host != null && ip != null && live > 0) {
            HttpServerManager.getInstance().addHttp3Server(host, ip, live);
        }
    }

    private void reportRequest(ResponseInfo responseInfo, IUploadServer server, UploadSingleRequestMetrics requestMetrics) {
        if (this.token == null || !this.token.isValid() || this.requestInfo == null || !this.requestInfo.shouldReportRequestLog() || requestMetrics == null) {
            return;
        }
        long currentTimestamp = Utils.currentTimestamp();
        ReportItem item = new ReportItem();
        item.setReport("request", "log_type");
        item.setReport(requestMetrics.getStartDate().getTime() / 1000L, "up_time");
        item.setReport(ReportItem.requestReportStatusCode(responseInfo), "status_code");
        item.setReport(responseInfo != null ? responseInfo.reqId : null, "req_id");
        item.setReport(requestMetrics.getRequest() != null ? requestMetrics.getRequest().getHost() : null, "host");
        item.setReport(requestMetrics.getRemoteAddress(), "remote_ip");
        item.setReport(requestMetrics.getRemotePort(), "port");
        item.setReport(this.requestInfo.bucket, "target_bucket");
        item.setReport(this.requestInfo.key, "target_key");
        item.setReport(requestMetrics.totalElapsedTime(), "total_elapsed_time");
        item.setReport(requestMetrics.totalDnsTime(), "dns_elapsed_time");
        item.setReport(requestMetrics.totalConnectTime(), "connect_elapsed_time");
        item.setReport(requestMetrics.totalSecureConnectTime(), "tls_connect_elapsed_time");
        item.setReport(requestMetrics.totalRequestTime(), "request_elapsed_time");
        item.setReport(requestMetrics.totalWaitTime(), "wait_elapsed_time");
        item.setReport(requestMetrics.totalWaitTime(), "response_elapsed_time");
        item.setReport(requestMetrics.totalResponseTime(), "response_elapsed_time");
        item.setReport(this.requestInfo.fileOffset, "file_offset");
        item.setReport(requestMetrics.bytesSend(), "bytes_sent");
        item.setReport(requestMetrics.totalBytes(), "bytes_total");
        item.setReport(Utils.getCurrentProcessID(), "pid");
        item.setReport(Utils.getCurrentThreadID(), "tid");
        item.setReport(this.requestInfo.targetRegionId, "target_region_id");
        item.setReport(this.requestInfo.currentRegionId, "current_region_id");
        String errorType = ReportItem.requestReportErrorType(responseInfo);
        item.setReport(errorType, "error_type");
        String errorDesc = null;
        if (responseInfo != null && errorType != null) {
            errorDesc = responseInfo.error != null ? responseInfo.error : responseInfo.message;
        }
        item.setReport(errorDesc, "error_description");
        item.setReport(this.requestInfo.requestType, "up_type");
        item.setReport(Utils.systemName(), "os_name");
        item.setReport(Utils.systemVersion(), "os_version");
        item.setReport(Utils.sdkLanguage(), "sdk_name");
        item.setReport(Utils.sdkVerion(), "sdk_version");
        item.setReport(currentTimestamp, "client_time");
        item.setReport(Utils.getCurrentNetworkType(), "network_type");
        item.setReport(Utils.getCurrentSignalStrength(), "signal_strength");
        item.setReport(server.getSource(), "prefetched_dns_source");
        if (server.getIpPrefetchedTime() != null) {
            Long prefetchTime = currentTimestamp / 1000L - server.getIpPrefetchedTime();
            item.setReport(prefetchTime, "prefetched_before");
        }
        item.setReport(DnsPrefetcher.getInstance().lastPrefetchErrorMessage, "prefetched_error_message");
        item.setReport(requestMetrics.getClientName(), "http_client");
        item.setReport(requestMetrics.getClientVersion(), "http_client_version");
        if (!GlobalConfiguration.getInstance().connectCheckEnable) {
            item.setReport("disable", "network_measuring");
        } else if (requestMetrics.getConnectCheckMetrics() != null) {
            String connectCheckDuration = String.format(Locale.ENGLISH, "%d", requestMetrics.getConnectCheckMetrics().totalElapsedTime());
            String connectCheckStatusCode = "";
            if (requestMetrics.getConnectCheckMetrics().getResponse() != null) {
                connectCheckStatusCode = String.format(Locale.ENGLISH, "%d", requestMetrics.getConnectCheckMetrics().getResponse().statusCode);
            }
            String networkMeasuring = String.format("duration:%s status_code:%s", connectCheckDuration, connectCheckStatusCode);
            item.setReport(networkMeasuring, "network_measuring");
        }
        item.setReport(requestMetrics.getHijacked(), "hijacking");
        item.setReport(requestMetrics.getSyncDnsSource(), "dns_source");
        item.setReport(requestMetrics.getSyncDnsError(), "dns_error_message");
        if (responseInfo.isOK()) {
            item.setReport(requestMetrics.perceptiveSpeed(), "perceptive_speed");
        }
        item.setReport(requestMetrics.getHttpVersion(), "http_version");
        UploadInfoReporter.getInstance().report(item, this.token.token);
    }

    static interface RequestCompleteHandler {
        public void complete(ResponseInfo var1, ArrayList<UploadSingleRequestMetrics> var2, JSONObject var3);
    }
}

