/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.dns;

import com.qiniu.android.http.dns.DnsNetworkAddress;
import com.qiniu.android.http.dns.IDnsNetworkAddress;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DnsCacheInfo
implements Serializable {
    private String currentTime;
    private String localIp;
    private ConcurrentHashMap<String, List<IDnsNetworkAddress>> info;

    public static DnsCacheInfo createDnsCacheInfoByData(byte[] jsonData) {
        if (jsonData == null) {
            return null;
        }
        JSONObject cacheInfoJSONObject = null;
        try {
            cacheInfoJSONObject = new JSONObject(new String(jsonData));
        }
        catch (Exception ignored) {
            return null;
        }
        String currentTime = null;
        String localIp = null;
        ConcurrentHashMap<String, List<IDnsNetworkAddress>> info = new ConcurrentHashMap<String, List<IDnsNetworkAddress>>();
        try {
            currentTime = cacheInfoJSONObject.getString("currentTime");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            localIp = cacheInfoJSONObject.getString("localIp");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONObject infoMapJSONObject = null;
        try {
            infoMapJSONObject = cacheInfoJSONObject.getJSONObject("info");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (currentTime == null || localIp == null || infoMapJSONObject == null) {
            return null;
        }
        Iterator it = infoMapJSONObject.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            try {
                ArrayList<DnsNetworkAddress> addressList = new ArrayList<DnsNetworkAddress>();
                JSONArray addressJSONArray = infoMapJSONObject.getJSONArray(key);
                for (int i = 0; i < addressJSONArray.length(); ++i) {
                    DnsNetworkAddress address = DnsNetworkAddress.address(addressJSONArray.getJSONObject(i));
                    addressList.add(address);
                }
                if (addressList.size() <= 0) continue;
                info.put(key, addressList);
            }
            catch (Exception exception) {}
        }
        return new DnsCacheInfo(currentTime, localIp, info);
    }

    public DnsCacheInfo() {
    }

    public DnsCacheInfo(String currentTime, String localIp, ConcurrentHashMap<String, List<IDnsNetworkAddress>> info) {
        this.currentTime = currentTime;
        this.localIp = localIp;
        this.info = info;
    }

    String getCurrentTime() {
        return this.currentTime;
    }

    String getLocalIp() {
        return this.localIp;
    }

    public ConcurrentHashMap<String, List<IDnsNetworkAddress>> getInfo() {
        return this.info;
    }

    void setCurrentTime(String currentTime) {
        this.currentTime = currentTime;
    }

    void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    public void setInfo(ConcurrentHashMap<String, List<IDnsNetworkAddress>> info) {
        this.info = info;
    }

    public String cacheKey() {
        return this.localIp;
    }

    public byte[] toJsonData() {
        JSONObject cacheInfoJSONObject = new JSONObject();
        try {
            cacheInfoJSONObject.putOpt("currentTime", (Object)this.currentTime);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            cacheInfoJSONObject.putOpt("localIp", (Object)this.localIp);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        JSONObject infoMapJSONObject = new JSONObject();
        for (String key : this.info.keySet()) {
            List<IDnsNetworkAddress> addressList = this.info.get(key);
            JSONArray addressJSONArray = new JSONArray();
            if (addressList != null) {
                for (IDnsNetworkAddress address : addressList) {
                    if (!(address instanceof DnsNetworkAddress)) continue;
                    try {
                        addressJSONArray.put((Object)((DnsNetworkAddress)address).toJson());
                    }
                    catch (Exception exception) {}
                }
            }
            if (addressJSONArray.length() <= 0) continue;
            try {
                infoMapJSONObject.put(key, (Object)addressJSONArray);
            }
            catch (JSONException jSONException) {}
        }
        try {
            cacheInfoJSONObject.putOpt("info", (Object)infoMapJSONObject);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return cacheInfoJSONObject.toString().getBytes();
    }

    public String toString() {
        return "{\"currentTime\":\"" + this.currentTime + "\", \"localIp\":\"" + this.localIp + "\"}";
    }
}

