/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import com.qiniu.android.http.UserAgent;
import com.qiniu.android.http.request.Request;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResponseInfo {
    @Deprecated
    public static final int ResquestSuccess = 200;
    public static final int RequestSuccess = 200;
    public static final int UnexpectedSysCallError = -10;
    @Deprecated
    public static final int NoUsableHostError = -9;
    public static final int SDKInteriorError = -9;
    public static final int MaliciousResponseError = -8;
    public static final int LocalIOError = -7;
    public static final int ZeroSizeFile = -6;
    public static final int InvalidToken = -5;
    public static final int InvalidArgument = -4;
    public static final int InvalidFile = -3;
    public static final int Cancelled = -2;
    public static final int NetworkError = -1;
    @Deprecated
    public static final int Crc32NotMatch = -406;
    public static final int UnknownError = 10000;
    public static final int TimedOut = -1001;
    public static final int UnknownHost = -1003;
    public static final int CannotConnectToHost = -1004;
    public static final int NetworkConnectionLost = -1005;
    public static final int NetworkSSLError = -1200;
    public static final int NetworkProtocolError = 100;
    public static final int NetworkSlow = -1009;
    public static final int ParseError = -1015;
    @Deprecated
    public static final int PasrseError = -1015;
    public final int statusCode;
    public final String httpVersion;
    public String message;
    public final String reqId;
    public final String xlog;
    public final String xvia;
    public final String error;
    public final String host;
    public final String id;
    public final long timeStamp;
    public final Map<String, String> responseHeader;
    public final JSONObject response;

    private ResponseInfo(JSONObject json, Map<String, String> responseHeader, String httpVersion, int statusCode, String reqId, String xlog, String xvia, String host, String error) {
        this.response = json;
        this.responseHeader = responseHeader;
        this.httpVersion = httpVersion;
        this.statusCode = statusCode;
        this.reqId = reqId != null ? reqId : "";
        this.xlog = xlog;
        this.xvia = xvia;
        this.host = host;
        this.id = UserAgent.instance().id;
        this.timeStamp = System.currentTimeMillis() / 1000L;
        if (error == null && !this.isOK()) {
            String errorP = null;
            if (this.response != null) {
                try {
                    errorP = this.response.getString("error");
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            this.error = errorP;
        } else {
            this.error = error;
        }
    }

    public static ResponseInfo successResponse() {
        ResponseInfo responseInfo = new ResponseInfo(null, null, null, 200, "inter:reqid", "inter:xlog", "inter:xvia", null, null);
        return responseInfo;
    }

    public static ResponseInfo zeroSize(String desc) {
        return ResponseInfo.errorInfo(-6, desc != null ? desc : "data size is 0");
    }

    public static ResponseInfo cancelled() {
        return ResponseInfo.errorInfo(-2, "cancelled by user");
    }

    public static ResponseInfo invalidArgument(String desc) {
        return ResponseInfo.errorInfo(-4, desc);
    }

    public static ResponseInfo invalidToken(String desc) {
        return ResponseInfo.errorInfo(-5, desc);
    }

    public static ResponseInfo fileError(Exception e) {
        return ResponseInfo.errorInfo(-3, e != null ? e.getMessage() : null);
    }

    public static ResponseInfo networkError(String desc) {
        return ResponseInfo.errorInfo(-1, desc);
    }

    public static ResponseInfo localIOError(String desc) {
        return ResponseInfo.errorInfo(-7, desc);
    }

    public static ResponseInfo maliciousResponseError(String desc) {
        return ResponseInfo.errorInfo(-8, desc);
    }

    @Deprecated
    public static ResponseInfo noUsableHostError(String desc) {
        return ResponseInfo.errorInfo(-9, desc);
    }

    public static ResponseInfo sdkInteriorError(String desc) {
        return ResponseInfo.errorInfo(-9, desc);
    }

    public static ResponseInfo parseError(String desc) {
        return ResponseInfo.errorInfo(-1015, desc);
    }

    public static ResponseInfo unexpectedSysCallError(String desc) {
        return ResponseInfo.errorInfo(-10, desc);
    }

    public static ResponseInfo errorInfo(int statusCode, String error) {
        ResponseInfo responseInfo = new ResponseInfo(null, null, "", statusCode, null, null, null, null, error);
        return responseInfo;
    }

    public static ResponseInfo create(Request request, int responseCode, Map<String, String> responseHeader, JSONObject response, String errorMessage) {
        return ResponseInfo.create(request, null, responseCode, responseHeader, response, errorMessage);
    }

    public static ResponseInfo create(Request request, String httpVersion, int responseCode, Map<String, String> responseHeader, JSONObject response, String errorMessage) {
        String host = request != null ? request.getHost() : null;
        String reqId = null;
        String xlog = null;
        String xvia = null;
        if (responseHeader != null) {
            reqId = responseHeader.get("x-reqid");
            xlog = responseHeader.get("x-log");
            if (responseHeader.get("x-via") != null) {
                xvia = responseHeader.get("x-via");
            } else if (responseHeader.get("x-px") != null) {
                xvia = responseHeader.get("x-px");
            } else if (responseHeader.get("fw-via") != null) {
                xvia = responseHeader.get("fw-via");
            }
        }
        ResponseInfo responseInfo = new ResponseInfo(response, responseHeader, httpVersion, responseCode, reqId, xlog, xvia, host, errorMessage);
        return responseInfo;
    }

    public ResponseInfo checkMaliciousResponse() {
        if (this.statusCode == 200 && this.reqId == null && this.xlog == null) {
            return new ResponseInfo(null, this.responseHeader, this.httpVersion, -8, this.reqId, this.xlog, this.xvia, this.host, "this is a malicious response");
        }
        return this;
    }

    public static boolean isStatusCodeForBrokenNetwork(int code) {
        return code == -1 || code == -1003 || code == -1004 || code == -1001 || code == -1005;
    }

    public boolean isCancelled() {
        return this.statusCode == -2;
    }

    public boolean isOK() {
        return this.statusCode == 200 && this.error == null && (this.hasReqId() || this.xlog != null);
    }

    public boolean couldRetry() {
        if (this.isNotQiniu()) {
            return true;
        }
        if (this.isCtxExpiredError()) {
            return true;
        }
        if (this.isTransferAccelerationConfigureError()) {
            return true;
        }
        return !(this.isCancelled() || this.statusCode == 100 || this.statusCode > 300 && this.statusCode < 400 || this.statusCode > 400 && this.statusCode < 500 && this.statusCode != 406 || this.statusCode == 501 || this.statusCode == 573 || this.statusCode == 608 || this.statusCode == 612 || this.statusCode == 614 || this.statusCode == 616 || this.statusCode == 619 || this.statusCode == 630 || this.statusCode == 631 || this.statusCode == 640) && (this.statusCode >= -1 || this.statusCode <= -1000);
    }

    public boolean couldRegionRetry() {
        if (this.isNotQiniu()) {
            return true;
        }
        if (this.isTransferAccelerationConfigureError()) {
            return true;
        }
        return !this.isCancelled() && this.statusCode != 100 && (this.statusCode <= 300 || this.statusCode >= 500 || this.statusCode == 406) && this.statusCode != 501 && this.statusCode != 573 && this.statusCode != 579 && this.statusCode != 608 && this.statusCode != 612 && this.statusCode != 614 && this.statusCode != 616 && this.statusCode != 619 && this.statusCode != 630 && this.statusCode != 631 && this.statusCode != 640 && this.statusCode != 701 && (this.statusCode >= -1 || this.statusCode <= -1000);
    }

    public boolean couldHostRetry() {
        if (this.isNotQiniu()) {
            return true;
        }
        if (this.isTransferAccelerationConfigureError()) {
            return false;
        }
        return !this.isCancelled() && this.statusCode != 100 && (this.statusCode <= 300 || this.statusCode >= 500 || this.statusCode == 406) && this.statusCode != 501 && this.statusCode != 502 && this.statusCode != 503 && this.statusCode != 571 && this.statusCode != 573 && this.statusCode != 579 && this.statusCode != 599 && this.statusCode != 608 && this.statusCode != 612 && this.statusCode != 614 && this.statusCode != 616 && this.statusCode != 619 && this.statusCode != 630 && this.statusCode != 631 && this.statusCode != 640 && this.statusCode != 701 && (this.statusCode >= -1 || this.statusCode <= -1000);
    }

    public boolean isTlsError() {
        return this.statusCode == -1200;
    }

    public boolean canConnectToHost() {
        return this.statusCode > 99 || this.isCancelled();
    }

    public boolean isHostUnavailable() {
        return this.isTransferAccelerationConfigureError() || this.statusCode == 502 || this.statusCode == 503 || this.statusCode == 504 || this.statusCode == 599;
    }

    public boolean isCtxExpiredError() {
        return this.statusCode == 701 || this.statusCode == 612 && this.error != null && this.error.contains("no such uploadId");
    }

    public boolean isTransferAccelerationConfigureError() {
        if (this.error == null) {
            return false;
        }
        return this.error.contains("transfer acceleration is not configured on this bucket");
    }

    public boolean isNetworkBroken() {
        return this.statusCode == -1 || this.statusCode == -1009;
    }

    public boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600 && this.statusCode != 579 || this.statusCode == 996;
    }

    public boolean needSwitchServer() {
        return this.isNetworkBroken() || this.isServerError();
    }

    public boolean needRetry() {
        return !this.isCancelled() && (this.needSwitchServer() || this.statusCode == 406 || this.statusCode == 200 && this.error != null || this.isNotQiniu());
    }

    public boolean isNotQiniu() {
        return this.statusCode == -8 || this.statusCode > 0 && !this.hasReqId() && this.xlog == null;
    }

    private boolean isQiniu() {
        return !this.isNotQiniu();
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "{ver:%s,ResponseInfo:%s,status:%d, reqId:%s, xlog:%s, xvia:%s, host:%s, time:%d,error:%s}", "8.8.0", this.id, this.statusCode, this.reqId, this.xlog, this.xvia, this.host, this.timeStamp, this.error);
    }

    public boolean hasReqId() {
        return this.reqId != null && this.reqId.length() > 0;
    }
}

