/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.common;

import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.utils.Cache;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ZonesInfo
implements Cloneable,
Cache.Object {
    private boolean isTemporary;
    public final ArrayList<ZoneInfo> zonesInfo = new ArrayList();
    private JSONObject jsonInfo;

    public ZonesInfo(JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        try {
            JSONArray hosts = jsonObject.getJSONArray("hosts");
            if (hosts.length() == 0) {
                return;
            }
            for (int i = 0; i < hosts.length(); ++i) {
                ZoneInfo zoneInfo = ZoneInfo.buildFromJson(hosts.getJSONObject(i));
                if (zoneInfo == null || !zoneInfo.isValid()) continue;
                this.zonesInfo.add(zoneInfo);
            }
            this.jsonInfo = jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ZonesInfo(List<ZoneInfo> zonesInfo) {
        this(zonesInfo, false);
    }

    public ZonesInfo(List<ZoneInfo> zonesInfo, boolean isTemporary) {
        this(ZonesInfo.createJsonWithZoneInfoList(zonesInfo));
        this.isTemporary = isTemporary;
    }

    public static ZonesInfo createZonesInfo(JSONObject jsonObject) {
        return new ZonesInfo(jsonObject);
    }

    public boolean isValid() {
        if (this.zonesInfo == null || this.zonesInfo.isEmpty()) {
            return false;
        }
        boolean valid = true;
        for (ZoneInfo info : this.zonesInfo) {
            if (info.isValid()) continue;
            valid = false;
            break;
        }
        return valid;
    }

    @Deprecated
    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Deprecated
    public void toTemporary() {
        this.isTemporary = true;
    }

    protected Object clone() throws CloneNotSupportedException {
        ArrayList<ZoneInfo> infos = new ArrayList<ZoneInfo>();
        if (this.zonesInfo != null && !this.zonesInfo.isEmpty()) {
            for (ZoneInfo zoneInfo : this.zonesInfo) {
                infos.add((ZoneInfo)zoneInfo.clone());
            }
        }
        ZonesInfo info = new ZonesInfo(infos);
        info.isTemporary = this.isTemporary;
        return info;
    }

    @Override
    public JSONObject toJson() {
        return this.jsonInfo;
    }

    private static JSONObject createJsonWithZoneInfoList(List<ZoneInfo> zonesInfo) {
        JSONArray zoneJsonArray = new JSONArray();
        for (ZoneInfo info : zonesInfo) {
            if (info == null || info.detailInfo == null) continue;
            zoneJsonArray.put((Object)info.detailInfo);
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("hosts", (Object)zoneJsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }
}

