/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.bigdata.client;

import com.qiniu.android.bigdata.client.CompletionHandler;
import com.qiniu.android.bigdata.client.PostArgs;
import com.qiniu.android.http.CancellationHandler;
import com.qiniu.android.http.ProgressHandler;
import com.qiniu.android.http.ProxyConfiguration;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.UrlConverter;
import com.qiniu.android.http.UserAgent;
import com.qiniu.android.http.dns.DnsPrefetcher;
import com.qiniu.android.http.dns.IDnsNetworkAddress;
import com.qiniu.android.http.request.httpclient.CountingRequestBody;
import com.qiniu.android.http.request.httpclient.MultipartBody;
import com.qiniu.android.storage.UpCancellationSignal;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.StringMap;
import com.qiniu.android.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public final class Client {
    public static final String ContentTypeHeader = "Content-Type";
    public static final String DefaultMime = "application/octet-stream";
    public static final String JsonMime = "application/json";
    public static final String FormMime = "application/x-www-form-urlencoded";
    private final UrlConverter converter;
    private OkHttpClient httpClient;

    public Client() {
        this(null, 10, 30, null, null);
    }

    public Client(ProxyConfiguration proxy, int connectTimeout, int responseTimeout, UrlConverter converter, com.qiniu.android.http.dns.Dns dns) {
        this.converter = converter;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (proxy != null) {
            builder.proxy(proxy.proxy());
            if (proxy.user != null && proxy.password != null) {
                builder.proxyAuthenticator(proxy.authenticator());
            }
        }
        builder.dns(new Dns(){

            public List<InetAddress> lookup(String hostname) throws UnknownHostException {
                List<IDnsNetworkAddress> networkAddressList = DnsPrefetcher.getInstance().getInetAddressByHost(hostname);
                if (networkAddressList != null && networkAddressList.size() > 0) {
                    ArrayList<InetAddress> inetAddressList = new ArrayList<InetAddress>();
                    for (IDnsNetworkAddress networkAddress : networkAddressList) {
                        InetAddress address = null;
                        if (networkAddress.getIpValue() == null || (address = InetAddress.getByName(networkAddress.getIpValue())) == null) continue;
                        inetAddressList.add(address);
                    }
                    if (inetAddressList.size() > 0) {
                        return inetAddressList;
                    }
                }
                return Dns.SYSTEM.lookup(hostname);
            }
        });
        builder.networkInterceptors().add(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                long before = System.currentTimeMillis();
                Response response = chain.proceed(request);
                long after = System.currentTimeMillis();
                ResponseTag tag = (ResponseTag)request.tag();
                String ip = "";
                try {
                    ip = chain.connection().socket().getRemoteSocketAddress().toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                tag.ip = ip;
                tag.duration = after - before;
                return response;
            }
        });
        builder.connectTimeout((long)connectTimeout, TimeUnit.SECONDS);
        builder.readTimeout((long)responseTimeout, TimeUnit.SECONDS);
        builder.writeTimeout(0L, TimeUnit.SECONDS);
        this.httpClient = builder.build();
    }

    private static String via(Response response) {
        String via = response.header("X-Via", "");
        if (!via.equals("")) {
            return via;
        }
        via = response.header("X-Px", "");
        if (!via.equals("")) {
            return via;
        }
        via = response.header("Fw-Via", "");
        if (!via.equals("")) {
            return via;
        }
        return via;
    }

    private static String ctype(Response response) {
        MediaType mediaType = response.body().contentType();
        if (mediaType == null) {
            return "";
        }
        return mediaType.type() + "/" + mediaType.subtype();
    }

    private static JSONObject buildJsonResp(byte[] body) throws Exception {
        String str = new String(body, "utf-8");
        if (StringUtils.isNullOrEmpty(str)) {
            return new JSONObject();
        }
        return new JSONObject(str);
    }

    private static ResponseInfo buildResponseInfo(Response response, String ip, long duration, UpToken upToken, long totalSize) {
        JSONObject json;
        String error;
        int code;
        block8: {
            code = response.code();
            String reqId = response.header("X-Reqid");
            reqId = reqId == null ? null : reqId.trim().split(",")[0];
            byte[] body = null;
            error = null;
            try {
                body = response.body().bytes();
            }
            catch (IOException e) {
                error = e.getMessage();
            }
            json = null;
            if (Client.ctype(response).equals(JsonMime) && body != null) {
                try {
                    json = Client.buildJsonResp(body);
                    if (response.code() != 200) {
                        String err = new String(body, "utf-8");
                        error = json.optString("error", err);
                    }
                    break block8;
                }
                catch (Exception e) {
                    if (response.code() < 300) {
                        error = e.getMessage();
                    }
                    break block8;
                }
            }
            error = body == null ? "null body" : new String(body);
        }
        HashMap<String, String> responseHeader = new HashMap<String, String>();
        int headerCount = response.headers().size();
        for (int i = 0; i < headerCount; ++i) {
            String name = response.headers().name(i).toLowerCase();
            String value = response.headers().value(i);
            responseHeader.put(name, value);
        }
        return ResponseInfo.create(null, code, responseHeader, json, error);
    }

    private static long getContentLength(Response response) {
        try {
            RequestBody body = response.request().body();
            if (body == null) {
                return 0L;
            }
            return body.contentLength();
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    private static void onRet(Response response, String ip, long duration, UpToken upToken, long totalSize, final CompletionHandler complete) {
        final ResponseInfo info = Client.buildResponseInfo(response, ip, duration, upToken, totalSize);
        AsyncRun.runInMain(new Runnable(){

            @Override
            public void run() {
                complete.complete(info, info.response);
            }
        });
    }

    public void asyncSend(final Request.Builder requestBuilder, StringMap headers, final UpToken upToken, final long totalSize, final CompletionHandler complete) {
        if (headers != null) {
            headers.forEach(new StringMap.Consumer(){
                final /* synthetic */ Client this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void accept(String key, Object value) {
                    requestBuilder.header(key, value.toString());
                }
            });
        }
        if (upToken != null) {
            requestBuilder.header("User-Agent", UserAgent.instance().getUa(upToken.accessKey));
        } else {
            requestBuilder.header("User-Agent", UserAgent.instance().getUa("pandora"));
        }
        ResponseTag tag = new ResponseTag();
        this.httpClient.newCall(requestBuilder.tag((Object)tag).build()).enqueue(new Callback(){
            final /* synthetic */ Client this$0;
            {
                this.this$0 = this$0;
            }

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
                int statusCode = -1;
                String msg = e.getMessage();
                if (e instanceof CancellationHandler.CancellationException) {
                    statusCode = -2;
                } else if (e instanceof UnknownHostException) {
                    statusCode = -1003;
                } else if (msg != null && msg.indexOf("Broken pipe") == 0) {
                    statusCode = -1005;
                } else if (e instanceof SocketTimeoutException) {
                    statusCode = -1001;
                } else if (e instanceof ConnectException) {
                    statusCode = -1004;
                }
                ResponseInfo responseInfo = ResponseInfo.create(null, statusCode, null, null, e.getMessage());
                complete.complete(responseInfo, null);
            }

            public void onResponse(Call call, Response response) throws IOException {
                ResponseTag tag = (ResponseTag)response.request().tag();
                Client.onRet(response, tag.ip, tag.duration, upToken, totalSize, complete);
            }
        });
    }

    public void asyncPost(String url, byte[] body, StringMap headers, UpToken upToken, long totalSize, ProgressHandler progressHandler, CompletionHandler completionHandler, UpCancellationSignal c) {
        this.asyncPost(url, body, 0, body.length, headers, upToken, totalSize, progressHandler, completionHandler, c);
    }

    public void asyncPost(String url, byte[] body, int offset, int size, StringMap headers, UpToken upToken, long totalSize, ProgressHandler progressHandler, CompletionHandler completionHandler, CancellationHandler c) {
        RequestBody rbody;
        if (this.converter != null) {
            url = this.converter.convert(url);
        }
        if (body != null && body.length > 0) {
            Object ct;
            MediaType t = MediaType.parse((String)DefaultMime);
            if (headers != null && (ct = headers.get(ContentTypeHeader)) != null) {
                t = MediaType.parse((String)ct.toString());
            }
            rbody = RequestBody.create((MediaType)t, (byte[])body, (int)offset, (int)size);
        } else {
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        if (progressHandler != null || c != null) {
            rbody = new CountingRequestBody(rbody, progressHandler, totalSize, c);
        }
        Request.Builder requestBuilder = new Request.Builder().url(url).post(rbody);
        this.asyncSend(requestBuilder, headers, upToken, totalSize, completionHandler);
    }

    public void asyncMultipartPost(String url, PostArgs args, UpToken upToken, ProgressHandler progressHandler, CompletionHandler completionHandler, CancellationHandler c) {
        long totalSize;
        RequestBody file;
        if (args.file != null) {
            file = RequestBody.create((MediaType)MediaType.parse((String)args.mimeType), (File)args.file);
            totalSize = args.file.length();
        } else {
            file = RequestBody.create((MediaType)MediaType.parse((String)args.mimeType), (byte[])args.data);
            totalSize = args.data.length;
        }
        this.asyncMultipartPost(url, args.params, upToken, totalSize, progressHandler, args.fileName, file, completionHandler, c);
    }

    private void asyncMultipartPost(String url, StringMap fields, UpToken upToken, long totalSize, ProgressHandler progressHandler, String fileName, RequestBody file, CompletionHandler completionHandler, CancellationHandler cancellationHandler) {
        if (this.converter != null) {
            url = this.converter.convert(url);
        }
        final MultipartBody.Builder mb = new MultipartBody.Builder();
        mb.addFormDataPart("file", fileName, file);
        fields.forEach(new StringMap.Consumer(){
            final /* synthetic */ Client this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(String key, Object value) {
                mb.addFormDataPart(key, value.toString());
            }
        });
        mb.setType(MediaType.parse((String)"multipart/form-data"));
        RequestBody body = mb.build();
        if (progressHandler != null || cancellationHandler != null) {
            body = new CountingRequestBody(body, progressHandler, totalSize, cancellationHandler);
        }
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        this.asyncSend(requestBuilder, null, upToken, totalSize, completionHandler);
    }

    public void asyncGet(String url, StringMap headers, UpToken upToken, CompletionHandler completionHandler) {
        Request.Builder requestBuilder = new Request.Builder().get().url(url);
        this.asyncSend(requestBuilder, headers, upToken, 0L, completionHandler);
    }

    public ResponseInfo syncGet(String url, StringMap headers) {
        Request.Builder requestBuilder = new Request.Builder().get().url(url);
        return this.send(requestBuilder, headers);
    }

    private ResponseInfo send(final Request.Builder requestBuilder, StringMap headers) {
        if (headers != null) {
            headers.forEach(new StringMap.Consumer(){
                final /* synthetic */ Client this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void accept(String key, Object value) {
                    requestBuilder.header(key, value.toString());
                }
            });
        }
        requestBuilder.header("User-Agent", UserAgent.instance().getUa(""));
        long start = System.currentTimeMillis();
        Response res = null;
        ResponseTag tag = new ResponseTag();
        Request req = requestBuilder.tag((Object)tag).build();
        try {
            res = this.httpClient.newCall(req).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResponseInfo.create(null, -1, null, null, e.getMessage());
        }
        return Client.buildResponseInfo(res, tag.ip, tag.duration, null, 0L);
    }

    public ResponseInfo syncMultipartPost(String url, PostArgs args, UpToken upToken) {
        long totalSize;
        RequestBody file;
        if (args.file != null) {
            file = RequestBody.create((MediaType)MediaType.parse((String)args.mimeType), (File)args.file);
            totalSize = args.file.length();
        } else {
            file = RequestBody.create((MediaType)MediaType.parse((String)args.mimeType), (byte[])args.data);
            totalSize = args.data.length;
        }
        return this.syncMultipartPost(url, args.params, upToken, totalSize, args.fileName, file);
    }

    private ResponseInfo syncMultipartPost(String url, StringMap fields, UpToken upToken, long totalSize, String fileName, RequestBody file) {
        final MultipartBody.Builder mb = new MultipartBody.Builder();
        mb.addFormDataPart("file", fileName, file);
        fields.forEach(new StringMap.Consumer(){
            final /* synthetic */ Client this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(String key, Object value) {
                mb.addFormDataPart(key, value.toString());
            }
        });
        mb.setType(MediaType.parse((String)"multipart/form-data"));
        MultipartBody body = mb.build();
        Request.Builder requestBuilder = new Request.Builder().url(url).post((RequestBody)body);
        return this.syncSend(requestBuilder, null, upToken, totalSize);
    }

    public ResponseInfo syncSend(final Request.Builder requestBuilder, StringMap headers, UpToken upToken, long totalSize) {
        if (headers != null) {
            headers.forEach(new StringMap.Consumer(){
                final /* synthetic */ Client this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void accept(String key, Object value) {
                    requestBuilder.header(key, value.toString());
                }
            });
        }
        requestBuilder.header("User-Agent", UserAgent.instance().getUa(upToken.accessKey));
        ResponseTag tag = new ResponseTag();
        Request req = null;
        try {
            req = requestBuilder.tag((Object)tag).build();
            Response response = this.httpClient.newCall(req).execute();
            return Client.buildResponseInfo(response, tag.ip, tag.duration, upToken, totalSize);
        }
        catch (Exception e) {
            e.printStackTrace();
            int statusCode = -1;
            String msg = e.getMessage();
            if (e instanceof UnknownHostException) {
                statusCode = -1003;
            } else if (msg != null && msg.indexOf("Broken pipe") == 0) {
                statusCode = -1005;
            } else if (e instanceof SocketTimeoutException) {
                statusCode = -1001;
            } else if (e instanceof ConnectException) {
                statusCode = -1004;
            }
            return ResponseInfo.create(null, statusCode, null, null, e.getMessage());
        }
    }

    private static class ResponseTag {
        public String ip = "";
        public long duration = -1L;

        private ResponseTag() {
        }
    }
}

