/*
 * Decompiled with CFR 0.152.
 */
package com.qihoo360.replugin.model;

import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.qihoo360.replugin.RePlugin;
import com.qihoo360.replugin.d;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import library.b;
import org.json.JSONException;
import org.json.JSONObject;

public class PluginInfo
implements Parcelable,
Serializable,
Cloneable {
    public static final int TYPE_NOT_INSTALL = 10;
    public static final int TYPE_EXTRACTED = 11;
    public static final int TYPE_PN_INSTALLED = 1;
    public static final int TYPE_BUILTIN = 2;
    public static final int TYPE_PN_JAR = 3;
    public static final int FRAMEWORK_VERSION_UNKNOWN = 0;
    public static final int ADAPTER_CURRENT_VERSION = 12;
    public static final String LOCAL_PLUGIN_DATA_SUB_DIR = "plugins_v3_data";
    private transient JSONObject a;
    private String b;
    private PluginInfo c;
    private PluginInfo d;
    private PluginInfo e;
    private boolean f;
    private PluginInfo g;
    public static final Parcelable.Creator<PluginInfo> CREATOR = new Parcelable.Creator<PluginInfo>(){

        public PluginInfo a(Parcel parcel) {
            return new PluginInfo(parcel);
        }

        public PluginInfo[] a(int n) {
            return new PluginInfo[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.a(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    private PluginInfo(JSONObject jSONObject) {
        this.a(jSONObject);
    }

    private void a(JSONObject jSONObject) {
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        this.a = jSONObject;
        JSONObject jSONObject4 = jSONObject.optJSONObject("upinfo");
        if (jSONObject4 != null) {
            this.c = new PluginInfo(jSONObject4);
        }
        if ((jSONObject3 = jSONObject.optJSONObject("delinfo")) != null) {
            this.d = new PluginInfo(jSONObject3);
        }
        if ((jSONObject2 = jSONObject.optJSONObject("coverinfo")) != null) {
            this.e = new PluginInfo(jSONObject2);
        }
        this.f = jSONObject.optBoolean("cover");
    }

    public String getName() {
        return this.a.optString("name");
    }

    public String getPackageName() {
        return this.a.optString("pkgname");
    }

    public String getAlias() {
        return this.a.optString("ali");
    }

    public int getVersion() {
        return this.a.optInt("ver");
    }

    public String getPath() {
        return this.a.optString("path");
    }

    public void setPath(String string) {
        library.b.a(this.a, "path", string);
    }

    public boolean isUsed() {
        if (this.isPnPlugin()) {
            return this.isDexExtracted();
        }
        if (this.getParentInfo() != null) {
            return this.getParentInfo().isUsed();
        }
        return this.a.optBoolean("used");
    }

    public void setIsUsed(boolean bl) {
        library.b.a(this.a, "used", bl);
    }

    public long getVersionValue() {
        return this.a.optLong("verv");
    }

    public boolean isDexExtracted() {
        File file = this.getDexFile();
        return file.exists() && file.length() > 0L;
    }

    public File getApkFile() {
        return new File(this.getApkDir(), this.makeInstalledFileName() + ".jar");
    }

    public String getApkDir() {
        Context context = com.qihoo360.replugin.d.a();
        File file = this.isPnPlugin() ? context.getDir("plugins_v3", 0) : (this.getIsPendingCover() ? context.getDir("p_c", 0) : context.getDir("p_a", 0));
        return file.getAbsolutePath();
    }

    @NonNull
    private File a(File file, String string) {
        File file2 = new File(file, this.makeInstalledFileName() + string);
        if (!file2.exists()) {
            file2.mkdir();
        }
        return file2;
    }

    public File getExtraDexDir() {
        return this.a(this.getDexParentDir(), "_ed");
    }

    public File getExtraOdexDir() {
        return this.a(this.getDexParentDir(), "_eod");
    }

    public File getDexParentDir() {
        Context context = com.qihoo360.replugin.d.a();
        if (Build.VERSION.SDK_INT > 25) {
            return new File(this.getApkDir() + File.separator + "oat" + File.separator + com.qihoo360.replugin.model.PluginInfo$a.b());
        }
        if (this.isPnPlugin()) {
            return context.getDir("plugins_v3_odex", 0);
        }
        if (this.getIsPendingCover()) {
            return context.getDir("p_c", 0);
        }
        return context.getDir("p_od", 0);
    }

    public File getDexFile() {
        if (Build.VERSION.SDK_INT > 25) {
            File file = this.getDexParentDir();
            return new File(file, this.makeInstalledFileName() + ".odex");
        }
        File file = this.getDexParentDir();
        return new File(file, this.makeInstalledFileName() + ".dex");
    }

    public File getNativeLibsDir() {
        Context context = com.qihoo360.replugin.d.a();
        File file = this.isPnPlugin() ? context.getDir("plugins_v3_libs", 0) : (this.getIsPendingCover() ? context.getDir("p_c", 0) : context.getDir("p_n", 0));
        return new File(file, this.makeInstalledFileName());
    }

    public int getType() {
        return this.a.optInt("type");
    }

    public void setType(int n) {
        library.b.a(this.a, "type", n);
    }

    public boolean isNeedUpdate() {
        return this.c != null;
    }

    public PluginInfo getPendingUpdate() {
        return this.c;
    }

    public boolean isNeedUninstall() {
        return this.d != null;
    }

    public PluginInfo getPendingDelete() {
        return this.d;
    }

    public boolean isNeedCover() {
        return this.e != null;
    }

    public PluginInfo getPendingCover() {
        return this.e;
    }

    public boolean getIsPendingCover() {
        return this.f;
    }

    public int getLowInterfaceApi() {
        return this.a.optInt("low", 10);
    }

    public int getHighInterfaceApi() {
        return this.a.optInt("high", 10);
    }

    public int getFrameworkVersion() {
        return this.a.optInt("frm_ver", 0);
    }

    public void setFrameworkVersion(int n) {
        library.b.a(this.a, "frm_ver", n);
    }

    public String makeInstalledFileName() {
        if (this.isPnPlugin() || this.getType() == 2) {
            return this.a();
        }
        String string = this.getPackageName().toLowerCase() + this.getLowInterfaceApi() + this.getHighInterfaceApi() + this.getVersion() + "ak";
        int n = string.hashCode() - 88;
        return Integer.toString(n);
    }

    public PluginInfo getParentInfo() {
        return this.g;
    }

    private PluginInfo(Parcel parcel) {
        JSONObject jSONObject = null;
        String string = null;
        try {
            string = parcel.readString();
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            jSONObject = new JSONObject();
        }
        this.a(jSONObject);
    }

    public Object clone() {
        PluginInfo pluginInfo = null;
        this.b = this.a != null ? this.a.toString() : null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            pluginInfo = (PluginInfo)objectInputStream.readObject();
            if (pluginInfo != null && !TextUtils.isEmpty((CharSequence)this.b)) {
                JSONObject jSONObject;
                JSONObject jSONObject2;
                pluginInfo.a = new JSONObject(this.b);
                JSONObject jSONObject3 = pluginInfo.a.optJSONObject("upinfo");
                if (jSONObject3 != null) {
                    pluginInfo.c = new PluginInfo(jSONObject3);
                }
                if ((jSONObject2 = pluginInfo.a.optJSONObject("delinfo")) != null) {
                    pluginInfo.d = new PluginInfo(jSONObject2);
                }
                if ((jSONObject = pluginInfo.a.optJSONObject("coverinfo")) != null) {
                    pluginInfo.e = new PluginInfo(jSONObject);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return pluginInfo;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.a.toString());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PInfo { ");
        this.a(stringBuilder);
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    private void a(StringBuilder stringBuilder) {
        Object[] objectArray;
        stringBuilder.append('<');
        stringBuilder.append(this.getName()).append(':').append(this.getVersion());
        stringBuilder.append('(').append(this.getFrameworkVersion()).append(')');
        stringBuilder.append("> ");
        if (this.g != null) {
            stringBuilder.append("[HAS_PARENT] ");
        }
        if (this.getType() == 2) {
            stringBuilder.append("[BUILTIN] ");
        } else if (this.isPnPlugin()) {
            stringBuilder.append("[P-N] ");
        } else {
            stringBuilder.append("[APK] ");
        }
        if (this.isDexExtracted()) {
            stringBuilder.append("[DEX_EXTRACTED] ");
        }
        if (RePlugin.isPluginRunning(this.getName())) {
            stringBuilder.append("[RUNNING] ");
        }
        if ((objectArray = RePlugin.getRunningProcessesByPlugin(this.getName())) != null) {
            stringBuilder.append("processes=").append(Arrays.toString(objectArray)).append(' ');
        }
        if (this.a != null) {
            stringBuilder.append("js=").append(this.a).append(' ');
        }
        stringBuilder.append("dex=").append(this.getDexFile()).append(' ');
        stringBuilder.append("nlib=").append(this.getNativeLibsDir());
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PluginInfo pluginInfo = (PluginInfo)object;
        try {
            return pluginInfo.a.toString().equals(this.a.toString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final String format(String string, int n, int n2, int n3) {
        return string + "-" + n + "-" + n2 + "-" + n3;
    }

    private String a() {
        return PluginInfo.format(this.getName(), this.getLowInterfaceApi(), this.getHighInterfaceApi(), this.getVersion());
    }

    public boolean isPnPlugin() {
        int n = this.getType();
        return n == 1 || n == 3 || n == 2;
    }

    private static class a {
        private static final byte[] a = new byte[0];
        private static volatile Boolean b;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean a() {
            if (b != null) {
                return b;
            }
            byte[] byArray = a;
            synchronized (a) {
                if (b != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return b;
                }
                b = com.qihoo360.replugin.model.PluginInfo$a.c();
                // ** MonitorExit[var0] (shouldn't be in output)
                return b;
            }
        }

        private static boolean c() {
            try {
                if (Build.VERSION.SDK_INT < 21) {
                    return false;
                }
                Class<?> clazz = Class.forName("dalvik.system.VMRuntime");
                if (clazz == null) {
                    return false;
                }
                Method method = clazz.getDeclaredMethod("getRuntime", new Class[0]);
                if (method == null) {
                    return false;
                }
                Object object = method.invoke(null, new Object[0]);
                if (object == null) {
                    return false;
                }
                Method method2 = clazz.getDeclaredMethod("is64Bit", new Class[0]);
                if (method2 == null) {
                    return false;
                }
                Object object2 = method2.invoke(object, new Object[0]);
                if (object2 instanceof Boolean) {
                    return (Boolean)object2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        public static String b() {
            return com.qihoo360.replugin.model.PluginInfo$a.a() ? "arm64" : "arm";
        }
    }
}

