/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.http.okhttp.intercepter;

import android.util.Log;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;

public class HttpLoggingInterceptor
implements Interceptor {
    public static final String TAG = "okhttp";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private volatile Level level = Level.NONE;
    private Logger logger;

    public HttpLoggingInterceptor(String tag) {
        this.logger = Logger.getLogger(tag);
    }

    static boolean isPlaintext(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        if (mediaType.type() != null && mediaType.type().equals("text")) {
            return true;
        }
        String subtype = mediaType.subtype();
        return subtype != null && ((subtype = subtype.toLowerCase()).contains("x-www-form-urlencoded") || subtype.contains("json") || subtype.contains("xml") || subtype.contains("html"));
    }

    public void log(String message) {
        this.logger.log(java.util.logging.Level.INFO, message);
    }

    public Level getLevel() {
        return this.level;
    }

    public HttpLoggingInterceptor setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException("level == null. Use Level.NONE instead.");
        }
        this.level = level;
        return this;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        if (this.level == Level.NONE) {
            return chain.proceed(request);
        }
        this.logForRequest(request, chain.connection());
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.log("<-- HTTP FAILED: " + e);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        return this.logForResponse(response, tookMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logForRequest(Request request, Connection connection) throws IOException {
        boolean logBody = this.level == Level.BODY;
        boolean logHeaders = this.level == Level.BODY || this.level == Level.HEADERS;
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        Protocol protocol = connection != null ? connection.protocol() : Protocol.HTTP_1_1;
        try {
            String requestStartMessage = "--> " + request.method() + ' ' + request.url() + ' ' + protocol;
            this.log(requestStartMessage);
            if (logHeaders) {
                Headers headers = request.headers();
                int count = headers.size();
                for (int i = 0; i < count; ++i) {
                    this.log("\t" + headers.name(i) + ": " + headers.value(i));
                }
                this.log(" ");
                if (logBody && hasRequestBody) {
                    if (HttpLoggingInterceptor.isPlaintext(requestBody.contentType())) {
                        this.bodyToString(request);
                    } else {
                        this.log("\tbody: maybe [file part] , too large too print , ignored!");
                    }
                }
            }
        }
        catch (Exception e) {
            OkLogger.e(e);
        }
        finally {
            this.log("--> END " + request.method());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response logForResponse(Response response, long tookMs) {
        Response.Builder builder = response.newBuilder();
        Response clone = builder.build();
        ResponseBody responseBody = clone.body();
        boolean logBody = this.level == Level.BODY;
        boolean logHeaders = this.level == Level.BODY || this.level == Level.HEADERS;
        try {
            this.log("<-- " + clone.code() + ' ' + clone.message() + ' ' + clone.request().url() + " (" + tookMs + "ms\uff09");
            if (logHeaders) {
                Headers headers = clone.headers();
                int count = headers.size();
                for (int i = 0; i < count; ++i) {
                    this.log("\t" + headers.name(i) + ": " + headers.value(i));
                }
                this.log(" ");
                if (logBody && HttpHeaders.hasBody((Response)clone)) {
                    if (HttpLoggingInterceptor.isPlaintext(responseBody.contentType())) {
                        String body = responseBody.string();
                        this.log("\tbody:" + body);
                        responseBody = ResponseBody.create((MediaType)responseBody.contentType(), (String)body);
                        Response response2 = response.newBuilder().body(responseBody).build();
                        return response2;
                    }
                    this.log("\tbody: maybe [file part] , too large too print , ignored!");
                }
            }
        }
        catch (Exception e) {
            OkLogger.e(e);
        }
        finally {
            this.log("<-- END HTTP");
        }
        return response;
    }

    private void bodyToString(Request request) {
        try {
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            copy.body().writeTo((BufferedSink)buffer);
            Charset charset = UTF8;
            MediaType contentType = copy.body().contentType();
            if (contentType != null) {
                charset = contentType.charset(UTF8);
            }
            this.log("\tbody:" + buffer.readString(charset));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class OkLogger {
        public static void e(Exception e) {
            if (e != null) {
                Log.w((String)HttpLoggingInterceptor.TAG, (String)e.getMessage());
            }
        }
    }

    public static enum Level {
        NONE,
        BASIC,
        HEADERS,
        BODY;

    }
}

