/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.http.okhttp.callback;

import com.zhy.http.okhttp.OkHttpUtils;
import com.zhy.http.okhttp.callback.Callback;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public abstract class FileCallBack
extends Callback<File> {
    private String destFileDir;
    private String destFileName;

    public FileCallBack(String destFileDir, String destFileName) {
        this.destFileDir = destFileDir;
        this.destFileName = destFileName;
    }

    @Override
    public File parseNetworkResponse(Response response, int id) throws Exception {
        return this.saveFile(response, id);
    }

    public File saveFile(Response response, final int id) throws IOException {
        boolean mkdirs;
        File dir = new File(this.destFileDir);
        if (dir.exists() || !(mkdirs = dir.mkdirs())) {
            // empty if block
        }
        File file = new File(dir, this.destFileName);
        Sink sink = Okio.sink((File)file);
        Source source = Okio.source((InputStream)response.body().byteStream());
        final long totalSize = response.body().contentLength();
        BufferedSink bufferedSink = Okio.buffer((Sink)sink);
        bufferedSink.writeAll((Source)new ForwardingSource(source){
            long sum;
            int oldRate;
            {
                super(x0);
                this.sum = 0L;
                this.oldRate = 0;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long readSize = super.read(sink, byteCount);
                if (readSize != -1L) {
                    this.sum += readSize;
                    final int rate = Math.round((float)this.sum * 1.0f / (float)totalSize * 100.0f);
                    if (this.oldRate != rate) {
                        OkHttpUtils.getInstance().getDelivery().execute(new Runnable(){

                            @Override
                            public void run() {
                                FileCallBack.this.inProgress((float)rate * 1.0f / 100.0f, totalSize, id);
                            }
                        });
                        this.oldRate = rate;
                    }
                }
                return readSize;
            }
        });
        bufferedSink.flush();
        Util.closeQuietly((Closeable)sink);
        Util.closeQuietly((Closeable)source);
        return file;
    }
}

