/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.http.okhttp.cookie.store;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.zhy.http.okhttp.cookie.store.CookieStore;
import com.zhy.http.okhttp.cookie.store.SerializableHttpCookie;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public class PersistentCookieStore
implements CookieStore {
    private static final String LOG_TAG = "PersistentCookieStore";
    private static final String COOKIE_PREFS = "CookiePrefsFile";
    private static final String COOKIE_NAME_PREFIX = "cookie_";
    private final HashMap<String, ConcurrentHashMap<String, Cookie>> cookies;
    private final SharedPreferences cookiePrefs;

    public PersistentCookieStore(Context context) {
        this.cookiePrefs = context.getSharedPreferences(COOKIE_PREFS, 0);
        this.cookies = new HashMap();
        Map prefsMap = this.cookiePrefs.getAll();
        for (Map.Entry entry : prefsMap.entrySet()) {
            String[] cookieNames;
            if ((String)entry.getValue() == null || ((String)entry.getValue()).startsWith(COOKIE_NAME_PREFIX)) continue;
            for (String name : cookieNames = TextUtils.split((String)((String)entry.getValue()), (String)",")) {
                Cookie decodedCookie;
                String encodedCookie = this.cookiePrefs.getString(COOKIE_NAME_PREFIX + name, null);
                if (encodedCookie == null || (decodedCookie = this.decodeCookie(encodedCookie)) == null) continue;
                if (!this.cookies.containsKey(entry.getKey())) {
                    this.cookies.put((String)entry.getKey(), new ConcurrentHashMap());
                }
                this.cookies.get(entry.getKey()).put(name, decodedCookie);
            }
        }
    }

    protected void add(HttpUrl uri, Cookie cookie) {
        String name = this.getCookieToken(cookie);
        if (cookie.persistent()) {
            if (!this.cookies.containsKey(uri.host())) {
                this.cookies.put(uri.host(), new ConcurrentHashMap());
            }
            this.cookies.get(uri.host()).put(name, cookie);
        } else if (this.cookies.containsKey(uri.host())) {
            this.cookies.get(uri.host()).remove(name);
        } else {
            return;
        }
        SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
        prefsWriter.putString(uri.host(), TextUtils.join((CharSequence)",", (Iterable)this.cookies.get(uri.host()).keySet()));
        prefsWriter.putString(COOKIE_NAME_PREFIX + name, this.encodeCookie(new SerializableHttpCookie(cookie)));
        prefsWriter.apply();
    }

    protected String getCookieToken(Cookie cookie) {
        return cookie.name() + cookie.domain();
    }

    @Override
    public void add(HttpUrl uri, List<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            this.add(uri, cookie);
        }
    }

    @Override
    public List<Cookie> get(HttpUrl uri) {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        if (this.cookies.containsKey(uri.host())) {
            Collection<Cookie> cookies = this.cookies.get(uri.host()).values();
            for (Cookie cookie : cookies) {
                if (PersistentCookieStore.isCookieExpired(cookie)) {
                    this.remove(uri, cookie);
                    continue;
                }
                ret.add(cookie);
            }
        }
        return ret;
    }

    private static boolean isCookieExpired(Cookie cookie) {
        return cookie.expiresAt() < System.currentTimeMillis();
    }

    @Override
    public boolean removeAll() {
        SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
        prefsWriter.clear();
        prefsWriter.apply();
        this.cookies.clear();
        return true;
    }

    @Override
    public boolean remove(HttpUrl uri, Cookie cookie) {
        String name = this.getCookieToken(cookie);
        if (this.cookies.containsKey(uri.host()) && this.cookies.get(uri.host()).containsKey(name)) {
            this.cookies.get(uri.host()).remove(name);
            SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
            if (this.cookiePrefs.contains(COOKIE_NAME_PREFIX + name)) {
                prefsWriter.remove(COOKIE_NAME_PREFIX + name);
            }
            prefsWriter.putString(uri.host(), TextUtils.join((CharSequence)",", (Iterable)this.cookies.get(uri.host()).keySet()));
            prefsWriter.apply();
            return true;
        }
        return false;
    }

    @Override
    public List<Cookie> getCookies() {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        for (String key : this.cookies.keySet()) {
            ret.addAll(this.cookies.get(key).values());
        }
        return ret;
    }

    protected String encodeCookie(SerializableHttpCookie cookie) {
        if (cookie == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(os);
            outputStream.writeObject(cookie);
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"IOException in encodeCookie", (Throwable)e);
            return null;
        }
        return this.byteArrayToHexString(os.toByteArray());
    }

    protected Cookie decodeCookie(String cookieString) {
        byte[] bytes = this.hexStringToByteArray(cookieString);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        Cookie cookie = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            cookie = ((SerializableHttpCookie)objectInputStream.readObject()).getCookie();
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"IOException in decodeCookie", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Log.d((String)LOG_TAG, (String)"ClassNotFoundException in decodeCookie", (Throwable)e);
        }
        return cookie;
    }

    protected String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            int v = element & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase(Locale.US);
    }

    protected byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }
}

