/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.upload;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.qfpay.clientstat.upload.UploadEventFileIntentService;
import com.qfpay.clientstat.upload.UploadJobService;
import com.qfpay.clientstat.upload.UploadStrategy;
import com.qfpay.clientstat.utils.Logger;
import java.io.File;
import java.util.Calendar;
import java.util.Date;

public class TimingUpload
implements UploadStrategy {
    private static final String TAG = "TimingUpload";
    private static final int DEFAULT_UPLOAD_PERIOD = 86400000;
    private Date firstTime;
    private int period;
    private Context context;
    private volatile boolean isSetAlarmTask = false;

    public TimingUpload(Context context, Date date, int n) {
        if (context == null) {
            throw new IllegalArgumentException("the context must not be null.");
        }
        if (date == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 23);
            calendar.set(12, 0);
            calendar.set(13, 0);
            date = calendar.getTime();
        }
        if (n <= 0) {
            n = 86400000;
        }
        this.context = context;
        this.firstTime = date;
        this.period = n;
    }

    @Override
    public boolean isSatisfied(File file) {
        if (!this.isSetAlarmTask) {
            this.isSetAlarmTask = true;
            PlatformCompat.scheduleUploadJob(this.context, this.firstTime, this.period);
        }
        return false;
    }

    private static class PlatformCompat {
        private PlatformCompat() {
        }

        static void scheduleUploadJob(Context context, Date date, int n) {
            block11: {
                if (Build.VERSION.SDK_INT >= 21) {
                    ComponentName componentName = new ComponentName(context, UploadJobService.class);
                    JobInfo.Builder builder = new JobInfo.Builder(250, componentName);
                    builder.setRequiredNetworkType(1);
                    if (Build.VERSION.SDK_INT >= 24) {
                        builder.setPeriodic((long)n, (long)n);
                    } else if (Build.VERSION.SDK_INT >= 21) {
                        builder.setPeriodic((long)n);
                    }
                    JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
                    if (jobScheduler == null) {
                        Logger.e(TimingUpload.TAG, "the job scheduler is null.", new Object[0]);
                        return;
                    }
                    try {
                        int n2 = jobScheduler.schedule(builder.build());
                        if (n2 == 0) {
                            Logger.e(TimingUpload.TAG, "start upload file job scheduler failed, please check.", new Object[0]);
                            break block11;
                        }
                        Logger.d(TimingUpload.TAG, "start upload file job scheduler success.", new Object[0]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Logger.e(TimingUpload.TAG, "start upload file job scheduler error: %s", exception.getMessage());
                    }
                } else {
                    PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)UploadEventFileIntentService.getCallingIntent(context), (int)0);
                    int n3 = 0;
                    AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
                    if (alarmManager == null) {
                        Logger.e(TimingUpload.TAG, "the alarm manager is null.", new Object[0]);
                        return;
                    }
                    if (Build.VERSION.SDK_INT >= 19) {
                        alarmManager.setWindow(n3, date.getTime(), (long)n, pendingIntent);
                    }
                    alarmManager.setRepeating(n3, date.getTime(), (long)n, pendingIntent);
                    Logger.d(TimingUpload.TAG, "set one repeat alarm task, first start at %s, and the interval time is %d", date.toString(), n);
                }
            }
        }
    }
}

