/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.upload;

import com.qfpay.clientstat.upload.UploadStrategy;
import com.qfpay.clientstat.utils.Logger;
import java.io.File;

public class MaxSizeUpload
implements UploadStrategy {
    private static final String TAG = "MaxSizeUpload";
    private static final int DEFAULT_MAX_FILE_SIZE = 5120;
    private int maxFileSize = 0;

    public MaxSizeUpload(int n) {
        if (n <= 0) {
            Logger.e(TAG, "can't set file limit size {'%s'} less than 0, use the default value {'%s'}.", n, 5120);
            n = 5120;
        }
        this.maxFileSize = n;
    }

    @Override
    public boolean isSatisfied(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        return file.length() >= (long)this.maxFileSize;
    }
}

