package com.qfpay.clientstat.upload;

import android.app.IntentService;
import android.content.Intent;
import android.content.Context;
import android.os.AsyncTask;

import com.qfpay.clientstat.ClientStat;
import com.qfpay.clientstat.StatProxy;
import com.qfpay.clientstat.internal.DefaultEventFileProvider;
import com.qfpay.clientstat.internal.EventFileProvider;
import com.qfpay.clientstat.internal.EventFileUploader;
import com.qfpay.clientstat.internal.EventHandler;
import com.qfpay.clientstat.internal.EventWriter;
import com.qfpay.clientstat.utils.DeviceUtil;
import com.qfpay.clientstat.utils.Logger;

import java.io.File;
import java.util.List;

/**
 * 上传统计文件Service
 */
public class UploadEventFileIntentService extends IntentService {
    private static final String TAG = "UploadEventFileIntentSe";
    public static final String ACTION_UPLOAD_EVENT_FILE = "action_upload_event_file";

    public UploadEventFileIntentService() {
        super("UploadEventFileIntentService");
    }

    public static Intent getCallingIntent(Context context) {
        Intent intent = new Intent(context, UploadEventFileIntentService.class);
        intent.setAction(ACTION_UPLOAD_EVENT_FILE);
        return intent;
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        Logger.d(TAG, "Intent service run thread name is %s", Thread.currentThread().getName());
        if (intent != null) {
            String action = intent.getAction();
            if (ACTION_UPLOAD_EVENT_FILE.equals(action)) {
                Logger.d(TAG, "trigger one upload event file service.");
                if (!DeviceUtil.isNetAvailable(getApplicationContext())) {
                    Logger.e(TAG, "current net work is not available, just return.");
                    return;
                }
                EventFileProvider eventFileProvider = null;
                StatProxy statProxy = StatProxy.getInstance();
                if (statProxy != null) {
                    EventHandler eventHandler = statProxy.getEventHandler();
                    if (eventHandler != null) {
                        EventWriter eventWriter = eventHandler.getEventWriter();
                        if (eventWriter != null) {
                            eventFileProvider = eventWriter.getEventFileProvider();
                        }
                    }
                }
                if (eventFileProvider == null) {
                    eventFileProvider = new DefaultEventFileProvider(getApplicationContext(), com.qfpay.clientstat.config.StatConfig.getInstance().getEventFilePath());
                }
                List<File> eventFiles = eventFileProvider.list();
                if (eventFiles != null) {
                    Logger.d(TAG, "there are %d files waite to upload.", eventFiles.size());
                    uploadEventFiles(eventFiles);
                }
            }
        }
    }

    private void uploadEventFiles(List<File> files) {
        if (files == null || files.size() <= 0) {
            Logger.e(TAG, "uploadEventFiles(): param files is null or empty.");
            return;
        }
        try {
            UploadFileAsyncTask uploadFileAsyncTask = new UploadFileAsyncTask();
            uploadFileAsyncTask.execute(files);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class UploadFileAsyncTask extends AsyncTask<List<File>, Integer, Boolean> {

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected Boolean doInBackground(List<File>... params) {
            Thread.currentThread().setName("client-stat-upload-cached-file-thread");
            if (params.length > 0) {
                List<File> files = params[0];
                if (files != null && files.size() > 0) {
                    EventFileUploader.uploadEventFileSync(files);
                }
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean aBoolean) {
            super.onPostExecute(aBoolean);

        }
    }
}
