/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.upload;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import com.qfpay.clientstat.StatProxy;
import com.qfpay.clientstat.config.StatConfig;
import com.qfpay.clientstat.internal.DefaultEventFileProvider;
import com.qfpay.clientstat.internal.EventFileProvider;
import com.qfpay.clientstat.internal.EventFileUploader;
import com.qfpay.clientstat.internal.EventHandler;
import com.qfpay.clientstat.internal.EventWriter;
import com.qfpay.clientstat.utils.DeviceUtil;
import com.qfpay.clientstat.utils.Logger;
import java.io.File;
import java.util.List;

public class UploadEventFileIntentService
extends IntentService {
    private static final String TAG = "UploadEventFileIntentSe";
    public static final String ACTION_UPLOAD_EVENT_FILE = "action_upload_event_file";

    public UploadEventFileIntentService() {
        super("UploadEventFileIntentService");
    }

    public static Intent getCallingIntent(Context context) {
        Intent intent = new Intent(context, UploadEventFileIntentService.class);
        intent.setAction(ACTION_UPLOAD_EVENT_FILE);
        return intent;
    }

    protected void onHandleIntent(Intent intent) {
        String action;
        Logger.d(TAG, "Intent service run thread name is %s", Thread.currentThread().getName());
        if (intent != null && ACTION_UPLOAD_EVENT_FILE.equals(action = intent.getAction())) {
            List<File> eventFiles;
            EventWriter eventWriter;
            EventHandler eventHandler;
            Logger.d(TAG, "trigger one upload event file service.", new Object[0]);
            if (!DeviceUtil.isNetAvailable(this.getApplicationContext())) {
                Logger.e(TAG, "current net work is not available, just return.", new Object[0]);
                return;
            }
            EventFileProvider eventFileProvider = null;
            StatProxy statProxy = StatProxy.getInstance();
            if (statProxy != null && (eventHandler = statProxy.getEventHandler()) != null && (eventWriter = eventHandler.getEventWriter()) != null) {
                eventFileProvider = eventWriter.getEventFileProvider();
            }
            if (eventFileProvider == null) {
                eventFileProvider = new DefaultEventFileProvider(this.getApplicationContext(), StatConfig.getInstance().getEventFilePath());
            }
            if ((eventFiles = eventFileProvider.list()) != null) {
                Logger.d(TAG, "there are %d files waite to upload.", eventFiles.size());
                this.uploadEventFiles(eventFiles);
            }
        }
    }

    private void uploadEventFiles(List<File> files) {
        if (files == null || files.size() <= 0) {
            Logger.e(TAG, "uploadEventFiles(): param files is null or empty.", new Object[0]);
            return;
        }
        try {
            UploadFileAsyncTask uploadFileAsyncTask = new UploadFileAsyncTask();
            uploadFileAsyncTask.execute(new List[]{files});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class UploadFileAsyncTask
    extends AsyncTask<List<File>, Integer, Boolean> {
        private UploadFileAsyncTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Boolean doInBackground(List<File> ... params) {
            List<File> files;
            Thread.currentThread().setName("client-stat-upload-cached-file-thread");
            if (params.length > 0 && (files = params[0]) != null && files.size() > 0) {
                EventFileUploader.uploadEventFileSync(files);
            }
            return true;
        }

        protected void onPostExecute(Boolean aBoolean) {
            super.onPostExecute((Object)aBoolean);
        }
    }
}

