/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.upload;

import com.qfpay.clientstat.upload.UploadStrategy;
import com.qfpay.clientstat.utils.Logger;
import java.io.File;

public class MaxSizeUpload
implements UploadStrategy {
    private static final String TAG = "MaxSizeUpload";
    private static final int DEFAULT_MAX_FILE_SIZE = 5120;
    private int maxFileSize = 0;

    public MaxSizeUpload(int maxFileSize) {
        if (maxFileSize <= 0) {
            Logger.e(TAG, "can't set file limit size {'%s'} less than 0, use the default value {'%s'}.", maxFileSize, 5120);
            maxFileSize = 5120;
        }
        this.maxFileSize = maxFileSize;
    }

    @Override
    public boolean isSatisfied(File eventFile) {
        if (eventFile == null || !eventFile.exists()) {
            return false;
        }
        return eventFile.length() >= (long)this.maxFileSize;
    }
}

