/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.serializer;

import com.qfpay.clientstat.event.Device;
import com.qfpay.clientstat.event.Event;
import com.qfpay.clientstat.serializer.Serializer;
import com.qfpay.clientstat.utils.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class DefaultSerializer
implements Serializer {
    private static final String TAG = "DefaultSerializer";
    private static final String SEPERATOR = "&";

    @Override
    public String serialize(Event event) {
        StringBuilder eventSb = new StringBuilder("");
        if (event == null) {
            Logger.e(TAG, "the event is null when serializing.", new Object[0]);
            return eventSb.toString();
        }
        eventSb.append(event.getEvent_type()).append(SEPERATOR).append(event.getEvent_key()).append(SEPERATOR).append(event.getEvent_value()).append(SEPERATOR).append(event.getEvent_time()).append(SEPERATOR);
        Device device = event.getDeviceInfo();
        if (device != null) {
            eventSb.append(this.urlEncode(device.getNet_env())).append(SEPERATOR).append(this.urlEncode(device.getApp_id())).append(SEPERATOR).append(this.urlEncode(device.getApp_name())).append(SEPERATOR).append(this.urlEncode(device.getApp_ver())).append(SEPERATOR).append(this.urlEncode(device.getUser_id())).append(SEPERATOR).append(this.urlEncode(device.getOs())).append(SEPERATOR).append(this.urlEncode(device.getOs_ver())).append(SEPERATOR).append(this.urlEncode(device.getDevice())).append(SEPERATOR).append(this.urlEncode(device.getOperator())).append(SEPERATOR).append(this.urlEncode(device.getLnglat())).append(SEPERATOR).append(this.urlEncode(device.getUdid())).append(SEPERATOR).append(this.urlEncode(device.getMac())).append(SEPERATOR).append(this.urlEncode(device.getImei())).append(SEPERATOR).append(this.urlEncode(device.getTime_diff() + "")).append(SEPERATOR);
        }
        eventSb.append(SEPERATOR).append(SEPERATOR);
        Map<String, String> param = event.getParams();
        JSONObject jsonParam = new JSONObject();
        if (param != null && !param.isEmpty()) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || value == null) continue;
                try {
                    jsonParam.put(key, (Object)value);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            eventSb.append(this.urlEncode(jsonParam.toString()));
        }
        return eventSb.toString() + "\n";
    }

    private String urlEncode(String originContent) {
        String encodeContent = "";
        if (originContent == null) {
            return encodeContent;
        }
        try {
            encodeContent = URLEncoder.encode(originContent.toString(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodeContent;
    }
}

