/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.internal;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.qfpay.clientstat.internal.EventFileProvider;
import com.qfpay.clientstat.utils.DeviceUtil;
import com.qfpay.clientstat.utils.FileUtil;
import com.qfpay.clientstat.utils.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class DefaultEventFileProvider
implements EventFileProvider {
    private static final String TAG = "DefaultEventFileProvide";
    public static final String EVENT_FILE_SUFFIX = ".event";
    private static final String EVENT_FILE_DIR = "client_stat";
    private Context mContext;
    private String mRelativeDir;
    private volatile boolean writeExternalStorageGranted = false;
    private String mProcessName = null;

    public DefaultEventFileProvider(Context context) {
        this(context, EVENT_FILE_DIR);
    }

    public DefaultEventFileProvider(Context context, String dirRelative) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null.");
        }
        if (dirRelative == null) {
            dirRelative = EVENT_FILE_DIR;
            Logger.e(TAG, "custom event file dir is null, just use default dir {'%s'}", EVENT_FILE_DIR);
        }
        this.mContext = context.getApplicationContext();
        this.mRelativeDir = dirRelative;
    }

    @Override
    public List<File> list() {
        File[] appFiles;
        File[] externalFiles;
        ArrayList<File> allEventFiles = new ArrayList<File>();
        FilenameFilter filenameFilter = this.eventFileFilter();
        if (this.hasStoragePermission(this.mContext) && (externalFiles = this.externalStorageDirectory().listFiles(filenameFilter)) != null) {
            allEventFiles.addAll(Arrays.asList(externalFiles));
        }
        if ((appFiles = this.appStorageDirectory().listFiles(filenameFilter)) != null) {
            allEventFiles.addAll(Arrays.asList(appFiles));
        }
        Logger.d(TAG, "list all event files, the all file's size is %d.", allEventFiles.size());
        return allEventFiles;
    }

    @Override
    public synchronized File newEventFile() throws IOException {
        boolean mkDirSuc;
        File dir = null;
        dir = this.hasStoragePermission(this.mContext) ? this.externalStorageDirectory() : this.appStorageDirectory();
        if (!dir.exists() && !(mkDirSuc = dir.mkdirs())) {
            Logger.e(TAG, "create dir '%s' failed.", dir.getAbsoluteFile());
        }
        this.ensureProcessName();
        File newExternalFile = new File(dir, this.mProcessName + "-" + System.currentTimeMillis() + EVENT_FILE_SUFFIX);
        boolean createFileSuc = newExternalFile.createNewFile();
        if (!createFileSuc) {
            Logger.e(TAG, "create file '%s' failed.", newExternalFile.getAbsoluteFile());
        } else {
            Logger.i(TAG, "create new event file {'%s'}", newExternalFile.getAbsoluteFile());
        }
        return newExternalFile;
    }

    @Override
    public void clearEventFiles() {
        File[] appFiles;
        File appDir;
        File[] externalFiles;
        File externalDir;
        if (this.hasStoragePermission(this.mContext) && (externalDir = this.externalStorageDirectory()).exists() && (externalFiles = externalDir.listFiles()) != null) {
            for (File file : externalFiles) {
                this.delEventFile(file);
            }
            Logger.d(TAG, "delete external event file size is %d", externalFiles.length);
        }
        if ((appDir = this.appStorageDirectory()).exists() && (appFiles = appDir.listFiles()) != null) {
            for (File file : appFiles) {
                this.delEventFile(file);
            }
            Logger.d(TAG, "delete app event file size is %d", appFiles.length);
        }
    }

    @Override
    public void delEventFile(File file) {
        if (file == null || !file.exists()) {
            Logger.e(TAG, "the file is null or not exist.", new Object[0]);
            return;
        }
        FileUtil.delFile(file);
    }

    private File externalStorageDirectory() {
        File downloadsDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        return new File(downloadsDir, File.separator + "client-stat-" + this.mContext.getPackageName() + this.mRelativeDir + File.separator);
    }

    private File appStorageDirectory() {
        File appFilesDir = this.mContext.getFilesDir();
        return new File(appFilesDir, this.mRelativeDir);
    }

    private boolean hasStoragePermission(Context context) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        if (this.writeExternalStorageGranted) {
            return true;
        }
        this.writeExternalStorageGranted = context.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
        return this.writeExternalStorageGranted;
    }

    private FilenameFilter eventFileFilter() {
        this.ensureProcessName();
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String fileName) {
                String[] part;
                if (fileName != null && (part = fileName.split("-")).length > 0) {
                    String firstPart = part[0];
                    return firstPart.equalsIgnoreCase(DefaultEventFileProvider.this.mProcessName);
                }
                return false;
            }
        };
    }

    private void ensureProcessName() {
        if (this.mProcessName == null) {
            this.mProcessName = DeviceUtil.getProcessName(this.mContext);
            Logger.d(TAG, "current process name is %s", this.mProcessName);
        }
    }
}

