package com.qfpay.clientstat.upload;

import android.app.job.JobParameters;
import android.app.job.JobService;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.RequiresApi;

import com.qfpay.clientstat.StatProxy;
import com.qfpay.clientstat.internal.DefaultEventFileProvider;
import com.qfpay.clientstat.internal.EventFileProvider;
import com.qfpay.clientstat.internal.EventFileUploader;
import com.qfpay.clientstat.internal.EventHandler;
import com.qfpay.clientstat.internal.EventWriter;
import com.qfpay.clientstat.utils.DeviceUtil;
import com.qfpay.clientstat.utils.Logger;

import java.io.File;
import java.util.List;

/**
 * 上传统计文件任务
 * <p>
 * Created by joye on 2017/9/27.
 */

@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
public class UploadJobService extends JobService {
    private static final String TAG = "UploadJobService";
    private JobParameters jobParameters;

    @Override
    public boolean onStartJob(JobParameters params) {
        this.jobParameters = params;
        Logger.d(TAG, "trigger one upload job service.");
        if (!DeviceUtil.isNetAvailable(getApplicationContext())) {
            Logger.e(TAG, "current net work is not available, just return.");
            jobFinished(params, false);
            return true;
        }
        EventFileProvider eventFileProvider = null;
        StatProxy statProxy = StatProxy.getInstance();
        if (statProxy != null) {
            EventHandler eventHandler = statProxy.getEventHandler();
            if (eventHandler != null) {
                EventWriter eventWriter = eventHandler.getEventWriter();
                if (eventWriter != null) {
                    eventFileProvider = eventWriter.getEventFileProvider();
                }
            }
        }
        if (eventFileProvider == null) {
            eventFileProvider = new DefaultEventFileProvider(getApplicationContext(), com.qfpay.clientstat.config.StatConfig.getInstance().getEventFilePath());
        }
        List<File> eventFiles = eventFileProvider.list();
        uploadEventFiles(eventFiles);
        //返回ture需要手动结束任务
        return true;
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        return false;
    }

    private void uploadEventFiles(List<File> files) {
        if (files == null || files.size() <= 0) {
            Logger.e(TAG, "uploadEventFiles(): param files is null or empty.");
            jobFinished(jobParameters, false);
            return;
        }
        try {
            UploadFileAsyncTask uploadFileAsyncTask = new UploadFileAsyncTask();
            uploadFileAsyncTask.execute(files);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class UploadFileAsyncTask extends AsyncTask<List<File>, Integer, Boolean> {

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected Boolean doInBackground(List<File>... params) {
            if (params.length > 0) {
                List<File> files = params[0];
                if (files != null && files.size() > 0) {
                    EventFileUploader.uploadEventFileSync(files);
                }
            }
            return true;
        }

        @Override
        protected void onPostExecute(Boolean aBoolean) {
            super.onPostExecute(aBoolean);
            jobFinished(jobParameters, false);
        }
    }
}
