package com.qfpay.clientstat.serializer;

import com.qfpay.clientstat.event.Device;
import com.qfpay.clientstat.event.Event;
import com.qfpay.clientstat.utils.Logger;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

/**
 * 默认序列化器
 */
public class DefaultSerializer implements Serializer {
    private static final String TAG = "DefaultSerializer";
    /**
     * 连接符
     */
    private static final String SEPERATOR = "&";

    /**
     * Default constructor
     */
    public DefaultSerializer() {
    }

    @Override
    public String serialize(Event event) {
        StringBuilder eventSb = new StringBuilder("");
        if (event == null) {
            Logger.e(TAG, "the event is null when serializing.");
            return eventSb.toString();
        }
        //事件信息
        eventSb.append(event.getEvent_type()).append(SEPERATOR)
                .append(event.getEvent_key()).append(SEPERATOR)
                .append(event.getEvent_value()).append(SEPERATOR)
                .append(event.getEvent_time()).append(SEPERATOR);
        //设备信息
        Device device = event.getDeviceInfo();
        if (device != null) {
            eventSb.append(urlEncode(device.getNet_env())).append(SEPERATOR)
                    .append(urlEncode(device.getApp_id())).append(SEPERATOR)
                    .append(urlEncode(device.getApp_name())).append(SEPERATOR)
                    .append(urlEncode(device.getApp_ver())).append(SEPERATOR)
                    .append(urlEncode(device.getUser_id())).append(SEPERATOR)
                    .append(urlEncode(device.getOs())).append(SEPERATOR)
                    .append(urlEncode(device.getOs_ver())).append(SEPERATOR)
                    .append(urlEncode(device.getDevice())).append(SEPERATOR)
                    .append(urlEncode(device.getOperator())).append(SEPERATOR)
                    .append(urlEncode(device.getLnglat())).append(SEPERATOR)
                    .append(urlEncode(device.getUdid())).append(SEPERATOR)
                    .append(urlEncode(device.getMac())).append(SEPERATOR)
                    .append(urlEncode(device.getImei())).append(SEPERATOR)
                    .append(urlEncode(device.getTime_diff() + "")).append(SEPERATOR);
        }
        //为了兼容旧格式中的httpStatus和syssn字段，此处按空处理
        eventSb.append(SEPERATOR).append(SEPERATOR);
        //额外参数
        Map<String, String> param = event.getParams();
        JSONObject jsonParam = new JSONObject();
        if (param != null && !param.isEmpty()) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null && value != null) {
                    try {
                        jsonParam.put(key, value);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
            eventSb.append(urlEncode(jsonParam.toString()));
        }

        return eventSb.toString() + "\n";
    }

    private String urlEncode(String originContent) {
        String encodeContent = "";
        if (originContent == null) return encodeContent;

        try {
            encodeContent = URLEncoder.encode(originContent.toString(), "utf-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodeContent;
    }
}