package com.qfpay.clientstat.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * 统计存储文件提供器
 * <p>
 * Created by joye on 2017/9/22.
 */

public interface EventFileProvider {

    /**
     * 获取所有事件统计文件
     *
     * @return 文件列表
     */
    List<File> list();

    /**
     * 创建新的事件统计文件
     *
     * @return 空文件
     * @throws IOException 文件读写异常
     */
    File newEventFile() throws IOException;

    /**
     * 清空事件统计文件，除去未上传的
     */
    void clearEventFiles();

    /**
     * 删除指定事件统计文件
     *
     * @param file 特定文件
     */
    void delEventFile(File file);
}
