package com.qfpay.clientstat.event;

import android.content.Context;

import java.util.*;

/**
 * 统计事件
 */
public class Event {
    /**
     * 计数统计类型
     */
    public static final int EVENT_TYPE_COUNT = 1;

    /**
     * 计算统计类型
     */
    public static final int EVENT_TYPE_CALCULATE = 2;

    public Event(Context context) {
        Device device = new Device(context);
        this.deviceInfo = device;
    }

    /**
     * 设备信息
     */
    private Device deviceInfo;

    /**
     * 事件类型：1 计数事件； 2 计算事件
     */
    private int event_type;

    /**
     * 事件关键字
     */
    private String event_key;

    /**
     * 事件值。当事件类型为计数事件时，此值为1.
     */
    private long event_value;

    /**
     * 事件客户端时间，单位毫秒
     */
    private long event_time;

    /**
     * 额外的参数
     */
    private Map params;

    /**
     * 构造函数
     *
     * @param type 事件类型
     * @param key  事件名称
     */
    public Event(int type, String key) {
        this(type, key, 1);
    }

    /**
     * 构造函数
     *
     * @param type  事件类型
     * @param key   事件名称
     * @param value 事件值
     */
    public Event(int type, String key, long value) {
        this.event_type = type;
        this.event_key = key;
        this.event_value = value;
    }

    public Device getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(Device deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public int getEvent_type() {
        return event_type;
    }

    public void setEvent_type(int event_type) {
        this.event_type = event_type;
    }

    public String getEvent_key() {
        return event_key;
    }

    public void setEvent_key(String event_key) {
        this.event_key = event_key;
    }

    public long getEvent_value() {
        return event_value;
    }

    public void setEvent_value(long event_value) {
        this.event_value = event_value;
    }

    public long getEvent_time() {
        return event_time;
    }

    public void setEvent_time(long event_time) {
        this.event_time = event_time;
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    @Override
    public String toString() {
        return "Event{" +
                "deviceInfo=" + deviceInfo +
                ", event_type=" + event_type +
                ", event_key='" + event_key + '\'' +
                ", event_value=" + event_value +
                ", event_time=" + event_time +
                ", params=" + params +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Event event = (Event) o;

        if (event_type != event.event_type) return false;
        if (event_value != event.event_value) return false;
        if (event_time != event.event_time) return false;
        if (deviceInfo != null ? !deviceInfo.equals(event.deviceInfo) : event.deviceInfo != null)
            return false;
        if (event_key != null ? !event_key.equals(event.event_key) : event.event_key != null)
            return false;
        return params != null ? params.equals(event.params) : event.params == null;

    }

    @Override
    public int hashCode() {
        int result = deviceInfo != null ? deviceInfo.hashCode() : 0;
        result = 31 * result + event_type;
        result = 31 * result + (event_key != null ? event_key.hashCode() : 0);
        result = 31 * result + (int) (event_value ^ (event_value >>> 32));
        result = 31 * result + (int) (event_time ^ (event_time >>> 32));
        result = 31 * result + (params != null ? params.hashCode() : 0);
        return result;
    }
}