package com.qfpay.clientstat.upload;

import android.support.v4.util.ArrayMap;

import com.qfpay.clientstat.utils.Logger;

import java.io.File;

/**
 * 指定数量上传
 */
public class QuantityUpload implements UploadStrategy {
    private static final String TAG = "QuantityUpload";
    /**
     * 限制条数
     */
    private int countLimit;

    /**
     * 记录日志文件存储条数
     */
    private ArrayMap<String, Integer> fileCountMap;

    /**
     * @param limit 限制条数
     */
    public QuantityUpload(int limit) {
        this.countLimit = limit;
        this.fileCountMap = new ArrayMap<>(2);
    }

    /**
     * 检查该文件对应存储条数是否超出限制
     *
     * @param eventFile 统计文件
     * @return 超出条数限制返回true，否则返回false
     */
    @Override
    public boolean isSatisfied(File eventFile) {
        if (eventFile == null || !eventFile.exists()) {
            Logger.e(TAG, "the param event file is null or not exist.");
            return false;
        }
        String fileName = eventFile.getName();
        if (fileCountMap.containsKey(fileName)) {
            int lastCount = fileCountMap.get(fileName);
            int nowCount = ++lastCount;
            if (nowCount >= countLimit) {
                fileCountMap.remove(fileName);
                return true;
            } else {
                fileCountMap.put(fileName, nowCount);
            }
        } else {
            fileCountMap.put(fileName, 1);
        }
        return false;
    }
}