package com.qfpay.clientstat;

import android.content.Context;

import com.qfpay.clientstat.utils.Logger;

import java.util.Map;

/**
 * 客户端统计
 * <p>
 * Created by joye on 2017/9/20.
 */

public class ClientStat {
    private static final String TAG = "ClientStat";
    private static com.qfpay.clientstat.config.StatConfig statConfig = com.qfpay.clientstat.config.StatConfig.getInstance();
    private static StatProxy statProxy = new StatProxy();

    public static StatProxy getStatProxy() {
        return statProxy;
    }

    public static void initWithConfig(com.qfpay.clientstat.config.StatConfig statConfig) {
        if (statConfig != null) {
            statProxy.setStatConfig(statConfig);
        }
    }

    public com.qfpay.clientstat.config.StatConfig getStatConfig() {
        return statConfig;
    }

    /**
     * 设置经纬度
     *
     * @param longitude 经度
     * @param latitude  纬度
     */
    public static void setLocation(double longitude, double latitude) {
        statConfig.setLnglat(longitude + "," + latitude);
    }

    /**
     * 设置用户信息
     *
     * @param userId 用户身份id
     */
    public static void onUserSignIn(String userId) {
        statConfig.setUserId(userId);
    }

    /**
     * 用户登出，不再统计用户信息
     */
    public static void onUserSignOff() {
        statConfig.setUserId("");
    }

    /**
     * 设置与服务端时间差
     *
     * @param timeDiff 时间差
     */
    public static void setTimeDiff(int timeDiff) {
        statConfig.setTimeDiff(timeDiff);
    }

    /**
     * 基础统计方法
     *
     * @param context 上下文
     * @param event   统计事件
     */
    public static void onEvent(Context context, String event) {
        onEvent(context, event, null);
    }

    /**
     * 基础统计方法
     *
     * @param context 上下文
     * @param event   统计事件
     * @param params  额外参数
     */
    public static void onEvent(Context context, String event, Map<String, String> params) {
        if (null == context) {
            Logger.e(TAG, "unexpected null context in onEvent");
            return;
        }
        statProxy.onEvent(context, event, params);
    }

    /**
     * 时长统计开始
     * see {@link #onEventEnd}
     *
     * @param context 上下文
     * @param event   事件Id (唯一)
     */
    public static void onEventBegin(Context context, String event) {
        if (null == context) {
            Logger.e(TAG, ("unexpected null context in onEventBegin"));
            return;
        }
        statProxy.onEventBegin(context, event);
    }

    /**
     * 时长统计结束
     *
     * @param context 上下文
     * @param event   事件key
     */
    public static void onEventEnd(Context context, String event) {
        onEventEnd(context, event, null);
    }

    /**
     * 时长统计结束
     *
     * @param context 上下文
     * @param event   事件key
     * @param params  额外参数
     */
    public static void onEventEnd(Context context, String event, Map<String, String> params) {
        statProxy.onEventEnd(context, event, params);
    }

    /**
     * 计算事件
     *
     * @param context 上下文
     * @param event   事件key
     * @param params  额外参数
     * @param value   事件值
     */
    public static void onEventValue(Context context, String event, Map<String, String> params, int value) {
        statProxy.onEventValue(context, event, params, value);
    }

    /**
     * 页面暂停
     *
     * @param context 上下文
     */
    public static void onPause(Context context) {
        statProxy.onPause(context);
    }

    /**
     * 页面恢复
     *
     * @param context 上下文
     */
    public static void onResume(Context context) {
        statProxy.onResume(context);
    }

}
