/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.UUID;

public class TelephonyUtils {
    private static final String TAG = "TelephonyUtils";
    private static final int NETWORK_TYPE_UNAVAILABLE = -1;
    private static final int NETWORK_TYPE_WIFI = -101;
    private static final int NETWORK_CLASS_WIFI = -101;
    private static final int NETWORK_CLASS_UNAVAILABLE = -1;
    private static final int NETWORK_CLASS_UNKNOWN = 0;
    private static final int NETWORK_CLASS_2_G = 1;
    private static final int NETWORK_CLASS_3_G = 2;
    private static final int NETWORK_CLASS_4_G = 3;
    private static DecimalFormat df = new DecimalFormat("#.##");
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;

    public static boolean isWifiAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 1;
    }

    public static String getMacAddress(Context context) {
        if (context == null) {
            return "";
        }
        String string = "";
        if (TelephonyUtils.isWifiAvailable(context)) {
            string = TelephonyUtils.getWifiMacAddress(context);
        }
        if (string != null && string.length() > 0) {
            string = string.replace(":", "-").toLowerCase(Locale.getDefault());
            return string;
        }
        string = string != null ? string.replace(":", "-").toLowerCase(Locale.getDefault()) : "";
        return string;
    }

    private static String getWifiMacAddress(Context context) {
        try {
            String string;
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            if (wifiManager.isWifiEnabled() && (string = wifiInfo.getMacAddress()) != null) {
                string = string.replace(":", "-").toLowerCase(Locale.getDefault());
                return string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static boolean isNetWorkEnable(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                return false;
            }
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected() && networkInfo.getState() == NetworkInfo.State.CONNECTED) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static String getSimOperator(Context context) {
        String string = "\u672a\u77e5";
        try {
            int n = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE");
            if (n == -1) {
                return "no permission";
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String string2 = telephonyManager.getSubscriberId();
            if (string2 == null) {
                String string3;
                if (5 == telephonyManager.getSimState() && (string3 = telephonyManager.getSimOperator()) != null) {
                    if (string3.equals("46000") || string3.equals("46002") || string3.equals("46007")) {
                        string = "\u4e2d\u56fd\u79fb\u52a8";
                    } else if (string3.equals("46001")) {
                        string = "\u4e2d\u56fd\u8054\u901a";
                    } else if (string3.equals("46003")) {
                        string = "\u4e2d\u56fd\u7535\u4fe1";
                    }
                }
            } else if (string2.startsWith("46000") || string2.startsWith("46002") || string2.startsWith("46007")) {
                string = "\u4e2d\u56fd\u79fb\u52a8";
            } else if (string2.startsWith("46001")) {
                string = "\u4e2d\u56fd\u8054\u901a";
            } else if (string2.startsWith("46003")) {
                string = "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static String getCurrentNetworkType(Context context) {
        int n = TelephonyUtils.getNetworkClass(context);
        String string = "\u672a\u77e5";
        switch (n) {
            case -1: {
                string = "\u65e0";
                break;
            }
            case -101: {
                string = "WIFI";
                break;
            }
            case 1: {
                string = "2G";
                break;
            }
            case 2: {
                string = "3G";
                break;
            }
            case 3: {
                string = "4G";
                break;
            }
            case 0: {
                string = "\u672a\u77e5";
            }
        }
        return string;
    }

    private static int getNetworkClassByType(int n) {
        switch (n) {
            case -1: {
                return -1;
            }
            case -101: {
                return -101;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 2;
            }
            case 13: {
                return 3;
            }
        }
        return 0;
    }

    private static int getNetworkClass(Context context) {
        int n = 0;
        try {
            int n2 = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE");
            if (n2 == -1) {
                return n;
            }
            NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
                int n3 = networkInfo.getType();
                if (n3 == 1) {
                    n = -101;
                } else if (n3 == 0) {
                    TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                    n = telephonyManager.getNetworkType();
                }
            } else {
                n = -1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return TelephonyUtils.getNetworkClassByType(n);
    }

    public static String getImei(Context context) {
        int n = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE");
        if (n == -1) {
            return "no permission";
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String string = telephonyManager.getDeviceId();
        if (string == null) {
            string = "000000000000000";
        }
        return string;
    }

    public static String getUDID(Context context) {
        String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        String string2 = "";
        try {
            String string3;
            string2 = !"9774d56d682e549c".equals(string) ? UUID.nameUUIDFromBytes(string.getBytes("utf8")).toString() : ((string3 = TelephonyUtils.getImei(context)) != null ? UUID.nameUUIDFromBytes(string3.getBytes("utf8")).toString() : UUID.randomUUID().toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static String getPackageName(Context context) {
        if (context == null || context.getPackageName() == null) {
            return "";
        }
        return context.getPackageName();
    }

    public static String getApplicationName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            return packageManager.getApplicationLabel(applicationInfo).toString();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return "";
        }
    }

    public static String getVersionName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "1.0";
        }
    }
}

