/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.UUID;

public class TelephonyUtils {
    private static final String TAG = "TelephonyUtils";
    private static final int NETWORK_TYPE_UNAVAILABLE = -1;
    private static final int NETWORK_TYPE_WIFI = -101;
    private static final int NETWORK_CLASS_WIFI = -101;
    private static final int NETWORK_CLASS_UNAVAILABLE = -1;
    private static final int NETWORK_CLASS_UNKNOWN = 0;
    private static final int NETWORK_CLASS_2_G = 1;
    private static final int NETWORK_CLASS_3_G = 2;
    private static final int NETWORK_CLASS_4_G = 3;
    private static DecimalFormat df = new DecimalFormat("#.##");
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;

    public static boolean isWifiAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 1;
    }

    public static String getMacAddress(Context context) {
        if (context == null) {
            return "";
        }
        String localMac = "";
        if (TelephonyUtils.isWifiAvailable(context)) {
            localMac = TelephonyUtils.getWifiMacAddress(context);
        }
        if (localMac != null && localMac.length() > 0) {
            localMac = localMac.replace(":", "-").toLowerCase(Locale.getDefault());
            return localMac;
        }
        localMac = TelephonyUtils.getMacFromCallCmd();
        localMac = localMac != null ? localMac.replace(":", "-").toLowerCase(Locale.getDefault()) : "";
        return localMac;
    }

    private static String getWifiMacAddress(Context context) {
        try {
            String localMac;
            WifiManager wifi = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            if (wifi.isWifiEnabled() && (localMac = info.getMacAddress()) != null) {
                localMac = localMac.replace(":", "-").toLowerCase(Locale.getDefault());
                return localMac;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getMacFromCallCmd() {
        String Mac;
        String result = "";
        result = TelephonyUtils.callCmd("busybox ifconfig", "HWaddr");
        if (result == null || result.length() <= 0) {
            return null;
        }
        if (result.length() > 0 && result.contains("HWaddr") && (Mac = result.substring(result.indexOf("HWaddr") + 6, result.length() - 1)).length() > 1) {
            result = Mac.replaceAll(" ", "");
        }
        return result;
    }

    public static String callCmd(String cmd, String filter) {
        String result = "";
        String line = "";
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            InputStreamReader is = new InputStreamReader(proc.getInputStream());
            BufferedReader br = new BufferedReader(is);
            while ((line = br.readLine()) != null && !line.contains(filter)) {
            }
            result = line;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("callCmd: can not get mac address by call cmd(busybox ifconfig), error is " + e.getMessage()));
        }
        return result;
    }

    public static boolean isNetWorkEnable(Context context) {
        try {
            ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivity == null) {
                return false;
            }
            NetworkInfo info = connectivity.getActiveNetworkInfo();
            if (info != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getSimOperator(Context context) {
        String provider = "\u672a\u77e5";
        try {
            int granted = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE");
            if (granted == -1) {
                return "no permission";
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String IMSI = telephonyManager.getSubscriberId();
            if (IMSI == null) {
                String operator;
                if (5 == telephonyManager.getSimState() && (operator = telephonyManager.getSimOperator()) != null) {
                    if (operator.equals("46000") || operator.equals("46002") || operator.equals("46007")) {
                        provider = "\u4e2d\u56fd\u79fb\u52a8";
                    } else if (operator.equals("46001")) {
                        provider = "\u4e2d\u56fd\u8054\u901a";
                    } else if (operator.equals("46003")) {
                        provider = "\u4e2d\u56fd\u7535\u4fe1";
                    }
                }
            } else if (IMSI.startsWith("46000") || IMSI.startsWith("46002") || IMSI.startsWith("46007")) {
                provider = "\u4e2d\u56fd\u79fb\u52a8";
            } else if (IMSI.startsWith("46001")) {
                provider = "\u4e2d\u56fd\u8054\u901a";
            } else if (IMSI.startsWith("46003")) {
                provider = "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return provider;
    }

    public static String getCurrentNetworkType(Context context) {
        int networkClass = TelephonyUtils.getNetworkClass(context);
        String type = "\u672a\u77e5";
        switch (networkClass) {
            case -1: {
                type = "\u65e0";
                break;
            }
            case -101: {
                type = "WIFI";
                break;
            }
            case 1: {
                type = "2G";
                break;
            }
            case 2: {
                type = "3G";
                break;
            }
            case 3: {
                type = "4G";
                break;
            }
            case 0: {
                type = "\u672a\u77e5";
            }
        }
        return type;
    }

    private static int getNetworkClassByType(int networkType) {
        switch (networkType) {
            case -1: {
                return -1;
            }
            case -101: {
                return -101;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 2;
            }
            case 13: {
                return 3;
            }
        }
        return 0;
    }

    private static int getNetworkClass(Context context) {
        int networkType = 0;
        try {
            int granted = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE");
            if (granted == -1) {
                return networkType;
            }
            NetworkInfo network = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
            if (network != null && network.isAvailable() && network.isConnected()) {
                int type = network.getType();
                if (type == 1) {
                    networkType = -101;
                } else if (type == 0) {
                    TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                    networkType = telephonyManager.getNetworkType();
                }
            } else {
                networkType = -1;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return TelephonyUtils.getNetworkClassByType(networkType);
    }

    public static String getImei(Context context) {
        int granted = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE");
        if (granted == -1) {
            return "no permission";
        }
        TelephonyManager mTelephonyMgr = (TelephonyManager)context.getSystemService("phone");
        String imei = mTelephonyMgr.getDeviceId();
        if (imei == null) {
            imei = "000000000000000";
        }
        return imei;
    }

    public static String getUDID(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        String udid = "";
        try {
            String deviceId;
            udid = !"9774d56d682e549c".equals(androidId) ? UUID.nameUUIDFromBytes(androidId.getBytes("utf8")).toString() : ((deviceId = TelephonyUtils.getImei(context)) != null ? UUID.nameUUIDFromBytes(deviceId.getBytes("utf8")).toString() : UUID.randomUUID().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return udid;
    }

    public static String getPackageName(Context context) {
        if (context == null || context.getPackageName() == null) {
            return "";
        }
        return context.getPackageName();
    }

    public static String getApplicationName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            return packageManager.getApplicationLabel(applicationInfo).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getVersionName(Context context) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            return info.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "1.0";
        }
    }
}

