/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.upload;

import android.annotation.SuppressLint;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.os.AsyncTask;
import com.qfpay.clientstat.ClientStat;
import com.qfpay.clientstat.StatProxy;
import com.qfpay.clientstat.config.StatConfig;
import com.qfpay.clientstat.internal.DefaultEventFileProvider;
import com.qfpay.clientstat.internal.EventFileProvider;
import com.qfpay.clientstat.internal.EventFileUploader;
import com.qfpay.clientstat.internal.EventHandler;
import com.qfpay.clientstat.internal.EventWriter;
import com.qfpay.clientstat.utils.DeviceUtil;
import com.qfpay.clientstat.utils.Logger;
import java.io.File;
import java.util.List;

@SuppressLint(value={"NewApi"})
public class UploadJobService
extends JobService {
    private static final String TAG = "UploadJobService";
    private JobParameters jobParameters;

    public boolean onStartJob(JobParameters params) {
        EventWriter eventWriter;
        EventHandler eventHandler;
        this.jobParameters = params;
        Logger.d(TAG, "trigger one upload job service.", new Object[0]);
        if (!DeviceUtil.isNetAvailable(this.getApplicationContext())) {
            Logger.e(TAG, "current net work is not available, just return.", new Object[0]);
            this.jobFinished(params, false);
            return true;
        }
        EventFileProvider eventFileProvider = null;
        StatProxy statProxy = ClientStat.getStatProxy();
        if (statProxy != null && (eventHandler = statProxy.getEventHandler()) != null && (eventWriter = eventHandler.getEventWriter()) != null) {
            eventFileProvider = eventWriter.getEventFileProvider();
        }
        if (eventFileProvider == null) {
            eventFileProvider = new DefaultEventFileProvider(this.getApplicationContext(), StatConfig.getInstance().getEventFilePath());
        }
        List<File> eventFiles = eventFileProvider.list();
        this.uploadEventFiles(eventFiles);
        return true;
    }

    public boolean onStopJob(JobParameters params) {
        return false;
    }

    private void uploadEventFiles(List<File> files) {
        if (files == null || files.size() <= 0) {
            Logger.e(TAG, "uploadEventFiles(): param files is null or empty.", new Object[0]);
            this.jobFinished(this.jobParameters, false);
            return;
        }
        try {
            UploadFileAsyncTask uploadFileAsyncTask = new UploadFileAsyncTask();
            uploadFileAsyncTask.execute(new List[]{files});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class UploadFileAsyncTask
    extends AsyncTask<List<File>, Integer, Boolean> {
        private UploadFileAsyncTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Boolean doInBackground(List<File> ... params) {
            List<File> files;
            if (params.length > 0 && (files = params[0]) != null && files.size() > 0) {
                EventFileUploader.uploadEventFileSync(files);
            }
            return true;
        }

        protected void onPostExecute(Boolean aBoolean) {
            super.onPostExecute((Object)aBoolean);
            UploadJobService.this.jobFinished(UploadJobService.this.jobParameters, false);
        }
    }
}

