/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.upload;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.qfpay.clientstat.upload.UploadEventFileIntentService;
import com.qfpay.clientstat.upload.UploadJobService;
import com.qfpay.clientstat.upload.UploadStrategy;
import com.qfpay.clientstat.utils.Logger;
import java.io.File;
import java.util.Calendar;
import java.util.Date;

public class TimingUpload
implements UploadStrategy {
    private static final String TAG = "TimingUpload";
    private static final int DEFAULT_UPLOAD_PERIOD = 86400;
    private Date firstTime;
    private int period;
    private Context context;
    private volatile boolean isSetAlarmTask = false;

    public TimingUpload(Context context, Date firstTime, int period) {
        if (context == null) {
            throw new IllegalArgumentException("the context must not be null.");
        }
        if (firstTime == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 23);
            calendar.set(12, 0);
            calendar.set(13, 0);
            firstTime = calendar.getTime();
        }
        if (period <= 0) {
            period = 86400;
        }
        this.context = context;
        this.firstTime = firstTime;
        this.period = period;
    }

    @Override
    public boolean isSatisfied(File eventFile) {
        if (!this.isSetAlarmTask) {
            this.isSetAlarmTask = true;
            PlatformCompat.scheduleUploadJob(this.context, this.firstTime, this.period);
        }
        return false;
    }

    private static class PlatformCompat {
        private PlatformCompat() {
        }

        static void scheduleUploadJob(Context context, Date firstTime, int period) {
            if (Build.VERSION.SDK_INT >= 21) {
                ComponentName jobServiceComponent = new ComponentName(context, UploadJobService.class);
                JobInfo.Builder jobBuilder = new JobInfo.Builder(250, jobServiceComponent);
                jobBuilder.setRequiredNetworkType(1);
                if (Build.VERSION.SDK_INT >= 24) {
                    jobBuilder.setPeriodic((long)period, (long)period);
                } else {
                    jobBuilder.setPeriodic((long)period);
                }
                JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
                int scheduleResult = jobScheduler.schedule(jobBuilder.build());
                if (scheduleResult == 0) {
                    Logger.e(TimingUpload.TAG, "start upload file job scheduler failed, please check.", new Object[0]);
                } else {
                    Logger.d(TimingUpload.TAG, "start upload file job scheduler success.", new Object[0]);
                }
            } else {
                PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)UploadEventFileIntentService.getCallingIntent(context), (int)0);
                int alarmType = 0;
                AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
                if (Build.VERSION.SDK_INT >= 19) {
                    alarmManager.setWindow(alarmType, firstTime.getTime(), (long)period, pendingIntent);
                }
                alarmManager.setRepeating(alarmType, firstTime.getTime(), (long)period, pendingIntent);
                Logger.d(TimingUpload.TAG, "set one repeat alarm task, first start at %s, and the interval time is %d", firstTime.toString(), period);
            }
        }
    }
}

