/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.upload;

import android.support.v4.util.ArrayMap;
import com.qfpay.clientstat.upload.UploadStrategy;
import com.qfpay.clientstat.utils.Logger;
import java.io.File;

public class QuantityUpload
implements UploadStrategy {
    private static final String TAG = "QuantityUpload";
    private int countLimit;
    private ArrayMap<String, Integer> fileCountMap;

    public QuantityUpload(int limit) {
        this.countLimit = limit;
        this.fileCountMap = new ArrayMap(2);
    }

    @Override
    public boolean isSatisfied(File eventFile) {
        if (eventFile == null || !eventFile.exists()) {
            Logger.e(TAG, "the param event file is null or not exist.", new Object[0]);
            return false;
        }
        String fileName = eventFile.getName();
        if (this.fileCountMap.containsKey((Object)fileName)) {
            int nowCount;
            int lastCount = (Integer)this.fileCountMap.get((Object)fileName);
            if ((nowCount = ++lastCount) >= this.countLimit) {
                this.fileCountMap.remove((Object)fileName);
                return true;
            }
            this.fileCountMap.put((Object)fileName, (Object)nowCount);
        } else {
            this.fileCountMap.put((Object)fileName, (Object)1);
        }
        return false;
    }
}

