/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.internal;

import android.content.Context;
import com.qfpay.clientstat.config.StatConfig;
import com.qfpay.clientstat.event.Event;
import com.qfpay.clientstat.internal.DefaultEventFileProvider;
import com.qfpay.clientstat.internal.EventFileProvider;
import com.qfpay.clientstat.internal.EventWriter;
import com.qfpay.clientstat.serializer.Serializer;
import com.qfpay.clientstat.utils.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

public class EventFileWriter
implements EventWriter {
    private static final String TAG = "EventFileWriter";
    private EventFileProvider eventFileProvider;
    private File eventFile;
    private Serializer serializer;

    public EventFileWriter(Context context, StatConfig statConfig) {
        this.eventFileProvider = new DefaultEventFileProvider(context, statConfig.getEventFilePath());
        this.serializer = statConfig.getSerializer();
    }

    @Override
    public synchronized File writeEvent(Event event) throws IOException {
        if (this.eventFile == null) {
            this.eventFile = this.eventFileProvider.newEventFile();
        }
        String eventContent = this.serializer.serialize(event);
        byte[] bytes = eventContent.getBytes("UTF-8");
        FileOutputStream fileOutputStream = new FileOutputStream(this.eventFile, true);
        fileOutputStream.write(bytes, 0, bytes.length);
        fileOutputStream.close();
        return this.eventFile;
    }

    @Override
    public File newFile() throws IOException {
        if (this.eventFileProvider == null) {
            Logger.e(TAG, "newFile(): the eventFileProvider instance is null.", new Object[0]);
            return null;
        }
        this.eventFile = this.eventFileProvider.newEventFile();
        return this.eventFile;
    }

    @Override
    public void deleteFile(File file) throws IOException {
        if (this.eventFileProvider == null) {
            Logger.e(TAG, "deleteFile(): the eventFileProvider instance is null.", new Object[0]);
            return;
        }
        this.eventFileProvider.delEventFile(file);
    }

    @Override
    public EventFileProvider getEventFileProvider() {
        return this.eventFileProvider;
    }

    @Override
    public List<File> getAllFiles() {
        if (this.eventFileProvider == null) {
            Logger.e(TAG, "getAllFiles(): the eventFileProvider instance is null.", new Object[0]);
            return null;
        }
        return this.eventFileProvider.list();
    }
}

