/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.internal;

import com.google.gson.reflect.TypeToken;
import com.qfpay.clientstat.ClientStat;
import com.qfpay.clientstat.internal.UploadResult;
import com.qfpay.clientstat.utils.FileUtil;
import com.qfpay.clientstat.utils.Logger;
import in.joye.urlconnection.UrlConnectionWrapper;
import in.joye.urlconnection.client.Call;
import in.joye.urlconnection.client.Callback;
import in.joye.urlconnection.client.Request;
import in.joye.urlconnection.client.RequestBuilder;
import in.joye.urlconnection.client.RequestType;
import in.joye.urlconnection.client.ResponseWrapper;
import in.joye.urlconnection.mime.TypedFile;
import java.io.File;
import java.io.IOException;
import java.util.List;

public final class EventFileUploader {
    private static final String TAG = "EventFileUploader";

    public static boolean uploadEventFileSync(List<File> fileList) {
        if (fileList != null) {
            UrlConnectionWrapper urlConnectionWrapper = UrlConnectionWrapper.getInstance();
            RequestBuilder requestBuilder = new RequestBuilder(ClientStat.getStatProxy().getStatConfig().getServerUrl(), "POST", RequestType.MULTIPART);
            boolean allUploadSuc = true;
            for (File file : fileList) {
                TypedFile typedFile = new TypedFile("file", file);
                requestBuilder.addMultiPart("stat", (Object)typedFile);
                Request uploadRequest = requestBuilder.build();
                Call call = urlConnectionWrapper.create(uploadRequest, new TypeToken<UploadResult>(){}.getType());
                try {
                    ResponseWrapper resultResponseWrapper = call.execute();
                    if (resultResponseWrapper == null) continue;
                    UploadResult uploadResult = (UploadResult)resultResponseWrapper.getResponseBody();
                    if (uploadResult != null && uploadResult.isUploadSuccess()) {
                        Logger.d(TAG, "upload file {'%s'} success, the result is %s.", file.getAbsoluteFile(), uploadResult);
                        FileUtil.delFile(file);
                        continue;
                    }
                    allUploadSuc = false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return allUploadSuc;
        }
        return false;
    }

    public static void uploadEventFileAsync(File file, Callback<UploadResult> callback) {
        if (file == null || !file.exists()) {
            Logger.e(TAG, "param 'file' is null or not exist.", new Object[0]);
            return;
        }
        if (callback == null) {
            Logger.e(TAG, "param 'callback' must not be null.", new Object[0]);
            return;
        }
        UrlConnectionWrapper urlConnectionWrapper = UrlConnectionWrapper.getInstance();
        RequestBuilder requestBuilder = new RequestBuilder(ClientStat.getStatProxy().getStatConfig().getServerUrl(), "POST", RequestType.MULTIPART);
        TypedFile typedFile = new TypedFile("file", file);
        requestBuilder.addMultiPart("stat", (Object)typedFile);
        Request uploadRequest = requestBuilder.build();
        Call call = urlConnectionWrapper.create(uploadRequest, new TypeToken<UploadResult>(){}.getType());
        call.enqueue(callback);
    }
}

