/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.internal;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.qfpay.clientstat.config.StatConfig;
import com.qfpay.clientstat.event.Event;
import com.qfpay.clientstat.internal.EventFileUploader;
import com.qfpay.clientstat.internal.EventFileWriter;
import com.qfpay.clientstat.internal.EventHandler;
import com.qfpay.clientstat.internal.EventWriter;
import com.qfpay.clientstat.internal.UploadResult;
import com.qfpay.clientstat.upload.UploadStrategy;
import com.qfpay.clientstat.utils.DeviceUtil;
import com.qfpay.clientstat.utils.Logger;
import in.joye.urlconnection.client.Callback;
import in.joye.urlconnection.client.Response;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefaultEventHandler
implements EventHandler {
    private static final String TAG = "DefaultEventHandler";
    private static final String THREAD_NAME_WRITE_FILE = "client-stat-write-file-thread";
    private Handler mEventHandler;
    private EventWriter eventWriter = null;

    public DefaultEventHandler() {
        Logger.i(TAG, "create new DefaultEventHandler instance.", new Object[0]);
    }

    @Override
    public void handleEvent(Context context, Event event, StatConfig statConfig) {
        context = context.getApplicationContext();
        if (this.mEventHandler == null) {
            this.createEventHandler(context, statConfig);
        }
        Message eventMsg = this.mEventHandler.obtainMessage();
        eventMsg.obj = event;
        this.mEventHandler.sendMessage(eventMsg);
    }

    @Override
    public EventWriter getEventWriter() {
        return this.eventWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createEventHandler(Context context, StatConfig statConfig) {
        if (this.mEventHandler != null) return;
        Class<DefaultEventHandler> clazz = DefaultEventHandler.class;
        synchronized (DefaultEventHandler.class) {
            if (this.mEventHandler != null) return;
            this.eventWriter = new EventFileWriter(context, statConfig);
            HandlerThread handlerThread = new HandlerThread(THREAD_NAME_WRITE_FILE, 10);
            handlerThread.start();
            this.mEventHandler = new EventWriteHandler(handlerThread.getLooper(), context, statConfig, this.eventWriter);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static class EventWriteHandler
    extends Handler {
        private EventWriter eventWriter;
        private List<UploadStrategy> uploadStrategyList;
        private Context context;
        private List<File> uploadingFiles;

        public EventWriteHandler(Looper looper, Context context, StatConfig statConfig, EventWriter eventWriter) {
            super(looper);
            this.context = context;
            this.eventWriter = eventWriter;
            this.uploadStrategyList = statConfig.getUploadStrategies();
            this.uploadingFiles = new ArrayList<File>();
        }

        public void handleMessage(Message msg) {
            try {
                Event event = (Event)msg.obj;
                if (event == null) {
                    Logger.e(DefaultEventHandler.TAG, "receive empty msg, and the event is null, just return.", new Object[0]);
                    return;
                }
                File eventFile = this.eventWriter.writeEvent(event);
                for (UploadStrategy uploadStrategy : this.uploadStrategyList) {
                    boolean satisfied = uploadStrategy.isSatisfied(eventFile);
                    if (!satisfied) continue;
                    File newFile = this.eventWriter.newFile();
                    Logger.i(DefaultEventHandler.TAG, "\u3010%s\u3011the event file {'%s'} is satisfied upload condition {'%s'}, upload now.", DeviceUtil.getProcessName(this.context), eventFile.getAbsoluteFile(), uploadStrategy.getClass().getSimpleName());
                    this.uploadEventFiles(newFile);
                    break;
                }
            }
            catch (IOException e) {
                Logger.e(DefaultEventHandler.TAG, "write event to file failed, the error is %s.", e.getMessage());
            }
            super.handleMessage(msg);
        }

        private void uploadEventFiles(File writingFile) {
            if (!DeviceUtil.isNetAvailable(this.context)) {
                Logger.w(DefaultEventHandler.TAG, "uploadEventFiles(): the current net is not available, just return.", new Object[0]);
                return;
            }
            if (writingFile == null || !writingFile.exists()) {
                Logger.e(DefaultEventHandler.TAG, "uploadEventFiles(): the writing file is null or not exists, this should not happened. just continue.", new Object[0]);
            }
            Logger.i(DefaultEventHandler.TAG, "There are %s files is uploading.", this.uploadingFiles.size());
            List<File> allFiles = this.eventWriter.getAllFiles();
            if (allFiles != null && allFiles.size() > 0) {
                allFiles.remove(writingFile);
                ArrayList<File> preparedFiles = new ArrayList<File>();
                for (File file : allFiles) {
                    if (!file.isFile() || this.uploadingFiles.contains(file)) continue;
                    preparedFiles.add(file);
                }
                Logger.i(DefaultEventHandler.TAG, "There are %s new file need to upload.", preparedFiles.size());
                if (preparedFiles.size() > 0) {
                    this.uploadingFiles.addAll(preparedFiles);
                    this.startUpload(preparedFiles);
                }
            }
        }

        private void startUpload(List<File> files) {
            for (final File eventFile : files) {
                if (eventFile.length() == 0L) {
                    try {
                        this.uploadingFiles.remove(eventFile);
                        this.eventWriter.deleteFile(eventFile);
                    }
                    catch (IOException e) {
                        Logger.e(DefaultEventHandler.TAG, "delete event file fail. the reason is %s", e.getMessage());
                    }
                    continue;
                }
                EventFileUploader.uploadEventFileAsync(eventFile, new Callback<UploadResult>(){

                    public void success(UploadResult uploadResult, Response response) {
                        Logger.i(DefaultEventHandler.TAG, "upload file success, the result is %s.", uploadResult);
                        if (uploadResult != null && uploadResult.isUploadSuccess()) {
                            try {
                                EventWriteHandler.this.uploadingFiles.remove(eventFile);
                                EventWriteHandler.this.eventWriter.deleteFile(eventFile);
                                Logger.i(DefaultEventHandler.TAG, "delete event file success.", new Object[0]);
                            }
                            catch (IOException e) {
                                Logger.e(DefaultEventHandler.TAG, "delete event file fail. the reason is %s", e.getMessage());
                            }
                        }
                    }

                    public void failure(int statusCode, String error) {
                        Logger.e(DefaultEventHandler.TAG, "upload file failed, the reason is %s", error);
                    }
                });
            }
        }
    }
}

