/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.config;

import com.qfpay.clientstat.serializer.DefaultSerializer;
import com.qfpay.clientstat.serializer.Serializer;
import com.qfpay.clientstat.upload.QuantityUpload;
import com.qfpay.clientstat.upload.UploadStrategy;
import java.util.ArrayList;
import java.util.List;

public class StatConfig {
    private static volatile StatConfig mInstance = new StatConfig();
    private static final String DEFAULT_UPLOAD_URL = "https://o.qfpay.com/clientlog/v1";
    private static final int DEFAULT_MAX_LOG_COUNT = 10;
    private static final String DEFAULT_LOG_DIR = "/clientstat/log/";
    private String eventFilePath;
    private String serverUrl;
    private List<UploadStrategy> uploadStrategies;
    private Serializer serializer;
    private long sessionDuration;
    private String lnglat;
    private String userId;
    private int timeDiff;
    private int serverConnectTimeout;
    private int serverRWTimeout;

    private StatConfig() {
    }

    private void StatisConfig() {
    }

    public static StatConfig getInstance() {
        return mInstance;
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public void setUploadStrategies(List<UploadStrategy> strategies) {
        this.uploadStrategies = strategies;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public void setSessionDuration(int duration) {
        this.sessionDuration = duration;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public int getTimeDiff() {
        return this.timeDiff;
    }

    public void setTimeDiff(int timeDiff) {
        this.timeDiff = timeDiff;
    }

    public String getEventFilePath() {
        if (this.eventFilePath == null) {
            this.eventFilePath = DEFAULT_LOG_DIR;
        }
        return this.eventFilePath;
    }

    public void setEventFilePath(String eventFilePath) {
        this.eventFilePath = eventFilePath;
    }

    public String getServerUrl() {
        if (this.serverUrl == null) {
            this.serverUrl = DEFAULT_UPLOAD_URL;
        }
        return this.serverUrl;
    }

    public List<UploadStrategy> getUploadStrategies() {
        if (this.uploadStrategies == null || this.uploadStrategies.size() == 0) {
            this.uploadStrategies = new ArrayList<UploadStrategy>(5);
            QuantityUpload quantityUs = new QuantityUpload(10);
            this.uploadStrategies.add(quantityUs);
        }
        return this.uploadStrategies;
    }

    public Serializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = new DefaultSerializer();
        }
        return this.serializer;
    }

    public long getSessionDuration() {
        return this.sessionDuration;
    }

    public String getLnglat() {
        return this.lnglat;
    }

    public void setSessionDuration(long sessionDuration) {
        this.sessionDuration = sessionDuration;
    }

    public void setLnglat(String lnglat) {
        this.lnglat = lnglat;
    }
}

