/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat;

import android.content.Context;
import android.support.v4.util.ArrayMap;
import com.qfpay.clientstat.config.StatConfig;
import com.qfpay.clientstat.event.Event;
import com.qfpay.clientstat.internal.DefaultEventHandler;
import com.qfpay.clientstat.internal.EventHandler;
import com.qfpay.clientstat.utils.Logger;
import java.util.Map;

public class StatProxy {
    private static final String TAG = "StatProxy";
    private StatConfig statConfig = StatConfig.getInstance();
    private EventHandler eventHandler;
    private ArrayMap<String, Long> hashMap = new ArrayMap();

    StatProxy() {
        this.eventHandler = new DefaultEventHandler();
    }

    void setStatConfig(StatConfig statConfig) {
        this.statConfig = statConfig;
    }

    void onEvent(Context context, String event, Map<String, String> params) {
        if (null == context) {
            Logger.e(TAG, "unexpected null context in onEvent", new Object[0]);
            return;
        }
        this.eventHandler.handleEvent(context, this.createEvent(context, event, params, 1L, 1), this.getStatConfig());
    }

    void onEventBegin(Context context, String event) {
        if (null == context) {
            Logger.e(TAG, "unexpected null context in onEventBegin", new Object[0]);
            return;
        }
        this.addToMap(event, System.currentTimeMillis());
    }

    void onEventEnd(Context context, String event, Map<String, String> params) {
        Long start = this.removeFromMap(event);
        if (start == null || start <= 0L) {
            Logger.w(TAG, "please call onEventBegin '" + event + "' before onPageEnd", new Object[0]);
            return;
        }
        long duration = System.currentTimeMillis() - start;
        if (duration <= Integer.MAX_VALUE && duration >= Integer.MIN_VALUE) {
            this.eventHandler.handleEvent(context, this.createEvent(context, event, params, duration, 2), this.getStatConfig());
        } else {
            Logger.w(TAG, "the event " + event + " time consuming is not accurate " + duration + " !", new Object[0]);
        }
    }

    void onEventValue(Context context, String event, Map<String, String> params, int value) {
        this.eventHandler.handleEvent(context, this.createEvent(context, event, params, value, 2), this.getStatConfig());
    }

    void onPause(Context context) {
    }

    void onResume(Context context) {
    }

    public StatConfig getStatConfig() {
        return this.statConfig;
    }

    private Event createEvent(Context context, String key, Map<String, String> params, long value, int type) {
        Event e = new Event(context);
        e.setEvent_key(key);
        e.setParams(params);
        e.setEvent_type(type);
        if (type == 1) {
            e.setEvent_value(1L);
        } else {
            e.setEvent_value(value);
        }
        e.setEvent_time(System.currentTimeMillis());
        e.getDeviceInfo().setLnglat(this.statConfig.getLnglat());
        e.getDeviceInfo().setUser_id(this.statConfig.getUserId());
        e.getDeviceInfo().setTime_diff(this.statConfig.getTimeDiff());
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMap(String key, long value) {
        ArrayMap<String, Long> arrayMap = this.hashMap;
        synchronized (arrayMap) {
            this.hashMap.put((Object)key, (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long removeFromMap(String key) {
        ArrayMap<String, Long> arrayMap = this.hashMap;
        synchronized (arrayMap) {
            return (Long)this.hashMap.remove((Object)key);
        }
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }
}

