package com.qfpay.clientstat.internal;

import android.content.Context;

import com.qfpay.clientstat.StatProxy;
import com.qfpay.clientstat.config.StatConfig;
import com.qfpay.clientstat.event.Event;
import com.qfpay.clientstat.serializer.Serializer;
import com.qfpay.clientstat.utils.Logger;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

/**
 * 事件磁盘写入器
 * <p>
 * Created by joye on 2017/9/20.
 */

public class EventFileWriter implements EventWriter {
    private static final String TAG = "EventFileWriter";
    private EventFileProvider eventFileProvider;
    private File eventFile;
    private Serializer serializer;

    public EventFileWriter(Context context, StatConfig statConfig) {
        this.eventFileProvider = new DefaultEventFileProvider(context, statConfig.getEventFilePath());
        this.serializer = statConfig.getSerializer();
    }

    @Override
    public synchronized File writeEvent(Event event) throws IOException {
        if (eventFile == null) {
            eventFile = eventFileProvider.newEventFile();
        }
        String eventContent = serializer.serialize(event);
        byte[] bytes = eventContent.getBytes("UTF-8");
        //抛出写异常
        FileOutputStream fileOutputStream = new FileOutputStream(eventFile, true);
        fileOutputStream.write(bytes, 0, bytes.length);
        fileOutputStream.close();
        return eventFile;
    }

    @Override
    public File newFile() throws IOException {
        if (eventFileProvider == null) {
            Logger.e(TAG, "newFile(): the eventFileProvider instance is null.");
            return null;
        }
        return this.eventFile = eventFileProvider.newEventFile();
    }

    @Override
    public void deleteFile(File file) throws IOException {
        if (eventFileProvider == null) {
            Logger.e(TAG, "deleteFile(): the eventFileProvider instance is null.");
            return;
        }
        eventFileProvider.delEventFile(file);
    }

    @Override
    public EventFileProvider getEventFileProvider() {
        return eventFileProvider;
    }

    @Override
    public List<File> getAllFiles() {
        if (eventFileProvider == null) {
            Logger.e(TAG, "getAllFiles(): the eventFileProvider instance is null.");
            return null;
        }
        return eventFileProvider.list();
    }
}
