/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.utils;

import android.util.Log;

public class Logger {
    private static boolean isDebug = false;
    private static LogImp defaultLog;
    private static LogImp printerLogImp;

    public static void setDebug(boolean debug) {
        isDebug = debug;
    }

    public static void v(String tag, String msg, Object ... objects) {
        if (printerLogImp != null && !isDebug) {
            printerLogImp.v(tag, msg, objects);
        }
    }

    public static void i(String tag, String msg, Object ... objects) {
        if (printerLogImp != null && !isDebug) {
            printerLogImp.i(tag, msg, objects);
        }
    }

    public static void d(String tag, String msg, Object ... objects) {
        if (printerLogImp != null && !isDebug) {
            printerLogImp.d(tag, msg, objects);
        }
    }

    public static void w(String tag, String msg, Object ... objects) {
        if (printerLogImp != null && !isDebug) {
            printerLogImp.w(tag, msg, objects);
        }
    }

    public static void e(String tag, String msg, Object ... objects) {
        if (printerLogImp != null && !isDebug) {
            printerLogImp.e(tag, msg, objects);
        }
    }

    public static void printErrStackTrace(String tag, Throwable throwable, String format, Object ... objects) {
        if (printerLogImp != null && !isDebug) {
            printerLogImp.printErrStackTrace(tag, throwable, format, objects);
        }
    }

    public static void setPrinterLogImp(LogImp printerLogImp) {
        Logger.printerLogImp = printerLogImp;
    }

    static {
        printerLogImp = defaultLog = new LogImp(){

            @Override
            public void v(String tag, String msg, Object ... objects) {
                String log = objects == null ? msg : String.format(msg, objects);
                Log.v((String)tag, (String)log);
            }

            @Override
            public void i(String tag, String msg, Object ... objects) {
                String log = objects == null ? msg : String.format(msg, objects);
                Log.i((String)tag, (String)log);
            }

            @Override
            public void d(String tag, String msg, Object ... objects) {
                String log = objects == null ? msg : String.format(msg, objects);
                Log.d((String)tag, (String)log);
            }

            @Override
            public void w(String tag, String msg, Object ... objects) {
                String log = objects == null ? msg : String.format(msg, objects);
                Log.w((String)tag, (String)log);
            }

            @Override
            public void e(String tag, String msg, Object ... objects) {
                String log = objects == null ? msg : String.format(msg, objects);
                Log.e((String)tag, (String)log);
            }

            @Override
            public void printErrStackTrace(String tag, Throwable throwable, String format, Object ... objects) {
                String log;
                String string = log = objects == null ? format : String.format(format, objects);
                if (log == null) {
                    log = "";
                }
                log = log + " " + Log.getStackTraceString((Throwable)throwable);
                Log.e((String)tag, (String)log);
            }
        };
    }

    public static interface LogImp {
        public void v(String var1, String var2, Object ... var3);

        public void i(String var1, String var2, Object ... var3);

        public void d(String var1, String var2, Object ... var3);

        public void w(String var1, String var2, Object ... var3);

        public void e(String var1, String var2, Object ... var3);

        public void printErrStackTrace(String var1, Throwable var2, String var3, Object ... var4);
    }
}

