/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.internal;

import android.content.Context;
import com.qfpay.clientstat.StatProxy;
import com.qfpay.clientstat.event.Event;
import com.qfpay.clientstat.internal.DefaultEventFileProvider;
import com.qfpay.clientstat.internal.EventFileProvider;
import com.qfpay.clientstat.internal.EventWriter;
import com.qfpay.clientstat.serializer.Serializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class EventFileWriter
implements EventWriter {
    private static final String TAG = "EventFileWriter";
    private EventFileProvider eventFileProvider;
    private File eventFile;
    private Serializer serializer;

    public EventFileWriter(Context context, StatProxy statProxy) {
        this.eventFileProvider = new DefaultEventFileProvider(context, statProxy.getStatConfig().getEventFilePath());
        this.serializer = statProxy.getStatConfig().getSerializer();
    }

    @Override
    public synchronized File writeEvent(Event event) throws IOException {
        if (this.eventFile == null) {
            this.eventFile = this.eventFileProvider.newEventFile();
        }
        String eventContent = this.serializer.serialize(event);
        byte[] bytes = eventContent.getBytes("UTF-8");
        FileOutputStream fileOutputStream = new FileOutputStream(this.eventFile, true);
        fileOutputStream.write(bytes, 0, bytes.length);
        fileOutputStream.close();
        return this.eventFile;
    }

    @Override
    public void newFile() throws IOException {
        if (this.eventFileProvider != null) {
            this.eventFile = this.eventFileProvider.newEventFile();
        }
    }

    @Override
    public void deleteFile(File file) throws IOException {
        if (this.eventFileProvider != null) {
            this.eventFileProvider.delEventFile(file);
        }
    }

    @Override
    public EventFileProvider getEventFileProvider() {
        return this.eventFileProvider;
    }
}

