/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat.internal;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.qfpay.clientstat.StatProxy;
import com.qfpay.clientstat.event.Event;
import com.qfpay.clientstat.internal.EventFileUploader;
import com.qfpay.clientstat.internal.EventFileWriter;
import com.qfpay.clientstat.internal.EventHandler;
import com.qfpay.clientstat.internal.EventWriter;
import com.qfpay.clientstat.internal.UploadResult;
import com.qfpay.clientstat.upload.UploadStrategy;
import com.qfpay.clientstat.utils.DeviceUtil;
import com.qfpay.clientstat.utils.Logger;
import in.joye.urlconnection.client.Callback;
import in.joye.urlconnection.client.Response;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class DefaultEventHandler
implements EventHandler {
    private static final String TAG = "DefaultEventHandler";
    private static final String THREAD_NAME_WRITE_FILE = "client-stat-write-file-thread";
    private Handler mEventHandler;
    private EventWriter eventWriter = null;

    public DefaultEventHandler() {
        Logger.i(TAG, "create new DefaultEventHandler instance.", new Object[0]);
    }

    @Override
    public void handleEvent(Context context, Event event, StatProxy statProxy) {
        if (this.mEventHandler == null) {
            this.createEventHandler(context, statProxy);
        }
        Message eventMsg = this.mEventHandler.obtainMessage();
        eventMsg.obj = event;
        this.mEventHandler.sendMessage(eventMsg);
    }

    @Override
    public EventWriter getEventWriter() {
        return this.eventWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createEventHandler(Context context, StatProxy statProxy) {
        if (this.mEventHandler != null) return;
        Class<DefaultEventHandler> clazz = DefaultEventHandler.class;
        synchronized (DefaultEventHandler.class) {
            if (this.mEventHandler != null) return;
            this.eventWriter = new EventFileWriter(context, statProxy);
            HandlerThread handlerThread = new HandlerThread(THREAD_NAME_WRITE_FILE, 10);
            handlerThread.start();
            this.mEventHandler = new EventWriteHandler(handlerThread.getLooper(), context, statProxy, this.eventWriter);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static class EventWriteHandler
    extends Handler {
        private EventWriter eventWriter;
        private List<UploadStrategy> uploadStrategyList;
        private Context context;

        public EventWriteHandler(Looper looper, Context context, StatProxy statProxy, EventWriter eventWriter) {
            super(looper);
            this.context = context;
            this.eventWriter = eventWriter;
            this.uploadStrategyList = statProxy.getStatConfig().getUploadStrategies();
        }

        public void handleMessage(Message msg) {
            try {
                Event event = (Event)msg.obj;
                if (event == null) {
                    Logger.e(DefaultEventHandler.TAG, "receive empty msg, and the event is null, just return.", new Object[0]);
                    return;
                }
                File eventFile = this.eventWriter.writeEvent(event);
                for (UploadStrategy uploadStrategy : this.uploadStrategyList) {
                    boolean satisfied = uploadStrategy.isSatisfied(eventFile);
                    if (!satisfied) continue;
                    this.eventWriter.newFile();
                    Logger.i(DefaultEventHandler.TAG, "\u3010%s\u3011the event file {'%s'} is satisfied upload condition {'%s'}, upload now.", DeviceUtil.getProcessName(this.context), eventFile.getAbsoluteFile(), uploadStrategy.getClass().getSimpleName());
                    this.uploadEventFile(eventFile);
                    break;
                }
            }
            catch (IOException e) {
                Logger.e(DefaultEventHandler.TAG, "write event to file failed, the error is %s.", e.getMessage());
            }
            super.handleMessage(msg);
        }

        private void uploadEventFile(final File eventFile) {
            if (eventFile == null || !eventFile.exists()) {
                Logger.e(DefaultEventHandler.TAG, "uploadEventFile(): the event file is null or not exists, just return.", new Object[0]);
                return;
            }
            if (!DeviceUtil.isNetAvailable(this.context)) {
                Logger.e(DefaultEventHandler.TAG, "uploadEventFile(): the current net is not available, just return.", new Object[0]);
                return;
            }
            Logger.i(DefaultEventHandler.TAG, "start upload event file {'%s'}", eventFile.getAbsoluteFile());
            EventFileUploader.uploadEventFileAsync(eventFile, new Callback<UploadResult>(){

                public void success(UploadResult uploadResult, Response response) {
                    Logger.i(DefaultEventHandler.TAG, "upload file success, the result is %s.", uploadResult);
                    if (uploadResult != null && uploadResult.isUploadSuccess()) {
                        try {
                            EventWriteHandler.this.eventWriter.deleteFile(eventFile);
                            Logger.i(DefaultEventHandler.TAG, "delete event file success.", new Object[0]);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            Logger.i(DefaultEventHandler.TAG, "delete event file fail.", new Object[0]);
                        }
                    }
                }

                public void failure(int statusCode, String error) {
                    Logger.e(DefaultEventHandler.TAG, "upload file failed, the reason is %s", error);
                }
            });
        }
    }
}

