/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.clientstat;

import android.content.Context;
import com.qfpay.clientstat.StatProxy;
import com.qfpay.clientstat.config.StatConfig;
import com.qfpay.clientstat.utils.Logger;
import java.util.Map;

public class ClientStat {
    private static final String TAG = "ClientStat";
    private static StatConfig statConfig = StatConfig.getInstance();
    private static StatProxy statProxy = new StatProxy();

    public static StatProxy getStatProxy() {
        return statProxy;
    }

    public static void initWithConfig(StatConfig statConfig) {
        if (statConfig != null) {
            statProxy.setStatConfig(statConfig);
        }
    }

    public StatConfig getStatConfig() {
        return statConfig;
    }

    public static void setLocation(double longitude, double latitude) {
        statConfig.setLnglat(longitude + "," + latitude);
    }

    public static void onUserSignIn(String userId) {
        statConfig.setUserId(userId);
    }

    public static void onUserSignOff() {
        statConfig.setUserId("");
    }

    public static void setTimeDiff(int timeDiff) {
        statConfig.setTimeDiff(timeDiff);
    }

    public static void onEvent(Context context, String event) {
        ClientStat.onEvent(context, event, null);
    }

    public static void onEvent(Context context, String event, Map<String, String> params) {
        if (null == context) {
            Logger.e(TAG, "unexpected null context in onEvent", new Object[0]);
            return;
        }
        statProxy.onEvent(context, event, params);
    }

    public static void onEventBegin(Context context, String event) {
        if (null == context) {
            Logger.e(TAG, "unexpected null context in onEventBegin", new Object[0]);
            return;
        }
        statProxy.onEventBegin(context, event);
    }

    public static void onEventEnd(Context context, String event) {
        ClientStat.onEventEnd(context, event, null);
    }

    public static void onEventEnd(Context context, String event, Map<String, String> params) {
        statProxy.onEventEnd(context, event, params);
    }

    public static void onEventValue(Context context, String event, Map<String, String> params, int value) {
        statProxy.onEventValue(context, event, params, value);
    }

    public static void onPause(Context context) {
        statProxy.onPause(context);
    }

    public static void onResume(Context context) {
        statProxy.onResume(context);
    }
}

