package com.qfpay.clientstat.utils;

import android.util.Log;

/**
 * 日志打印工具类
 * <p>
 * Created by joye on 2017/9/22.
 */

public class Logger {

    private static boolean isDebug = false;

    public interface LogImp {
        void v(final String tag, final String msg, final Object... objects);

        void i(final String tag, final String msg, final Object... objects);

        void d(final String tag, final String msg, final Object... objects);

        void w(final String tag, final String msg, final Object... objects);

        void e(final String tag, final String msg, final Object... objects);

        void printErrStackTrace(String tag, Throwable throwable, final String format, final Object... objects);
    }

    public static void setDebug(boolean debug) {
        isDebug = debug;
    }

    public static void v(final String tag, final String msg, final Object... objects) {
        if (printerLogImp != null && !isDebug) {
            printerLogImp.v(tag, msg, objects);
        }
    }

    public static void i(final String tag, final String msg, final Object... objects) {
        if (printerLogImp != null && !isDebug) {
            printerLogImp.i(tag, msg, objects);
        }
    }

    public static void d(final String tag, final String msg, final Object... objects) {
        if (printerLogImp != null && !isDebug) {
            printerLogImp.d(tag, msg, objects);
        }
    }

    public static void w(final String tag, final String msg, final Object... objects) {
        if (printerLogImp != null && !isDebug) {
            printerLogImp.w(tag, msg, objects);
        }
    }

    public static void e(final String tag, final String msg, final Object... objects) {
        if (printerLogImp != null && !isDebug) {
            printerLogImp.e(tag, msg, objects);
        }
    }

    public static void printErrStackTrace(String tag, Throwable throwable, final String format, final Object... objects) {
        if (printerLogImp != null && !isDebug) {
            printerLogImp.printErrStackTrace(tag, throwable, format, objects);
        }
    }

    private static LogImp defaultLog = new LogImp() {
        @Override
        public void v(String tag, String msg, Object... objects) {
            String log = objects == null ? msg : String.format(msg, objects);
            Log.v(tag, log);
        }

        @Override
        public void i(String tag, String msg, Object... objects) {
            String log = objects == null ? msg : String.format(msg, objects);
            Log.i(tag, log);
        }

        @Override
        public void d(String tag, String msg, Object... objects) {
            String log = objects == null ? msg : String.format(msg, objects);
            Log.d(tag, log);
        }

        @Override
        public void w(String tag, String msg, Object... objects) {
            String log = objects == null ? msg : String.format(msg, objects);
            Log.w(tag, log);
        }

        @Override
        public void e(String tag, String msg, Object... objects) {
            String log = objects == null ? msg : String.format(msg, objects);
            Log.e(tag, log);
        }

        @Override
        public void printErrStackTrace(String tag, Throwable throwable, String format, Object... objects) {
            String log = objects == null ? format : String.format(format, objects);
            if (log == null) {
                log = "";
            }
            log += " " + Log.getStackTraceString(throwable);
            Log.e(tag, log);
        }
    };

    private static LogImp printerLogImp = defaultLog;

    public static void setPrinterLogImp(LogImp printerLogImp) {
        Logger.printerLogImp = printerLogImp;
    }

}
