package com.qfpay.clientstat.upload;

import com.qfpay.clientstat.utils.Logger;

import java.io.File;

/**
 * 最大文件尺寸上传
 * <p>
 * Created by joye on 2017/9/27.
 */

public class MaxSizeUpload implements UploadStrategy {
    private static final String TAG = "MaxSizeUpload";
    private static final int DEFAULT_MAX_FILE_SIZE = 5 * 1024;
    /**
     * 最大文件尺寸
     * 单位 字节
     */
    private int maxFileSize = 0;

    public MaxSizeUpload(int maxFileSize) {
        if (maxFileSize <= 0) {
            Logger.e(TAG, "can't set file limit size {'%s'} less than 0, use the default value {'%s'}.", maxFileSize, DEFAULT_MAX_FILE_SIZE);
            maxFileSize = DEFAULT_MAX_FILE_SIZE;
        }
        this.maxFileSize = maxFileSize;
    }

    @Override
    public boolean isSatisfied(File eventFile) {
        if (eventFile == null || !eventFile.exists()) {
            return false;
        }
        return eventFile.length() >= maxFileSize;
    }
}
