package com.qfpay.clientstat.internal;

import com.qfpay.clientstat.event.Event;

import java.io.File;
import java.io.IOException;

/**
 * 统计事件写入接口
 * 文件创键、删除封装在EventFileProvider中
 * <p>
 * Created by joye on 2017/9/24.
 */

public interface EventWriter {

    /**
     * 写入事件
     *
     * @param events 统计事件
     * @return 已写入条数
     * @throws IOException 文件读写异常
     */
    File writeEvent(Event events) throws IOException;

    /**
     * 创建新文件
     *
     * @throws IOException 文件读写异常
     */
    void newFile() throws IOException;

    /**
     * 删除文件
     *
     * @param file 指定文件
     * @throws IOException 文件读写异常
     */
    void deleteFile(File file) throws IOException;

    /**
     * 获取文件提供器
     *
     * @return EventFileProvider
     */
    EventFileProvider getEventFileProvider();
}
