package com.qfpay.clientstat.internal;

import android.content.Context;

import com.qfpay.clientstat.StatProxy;
import com.qfpay.clientstat.event.Event;
import com.qfpay.clientstat.serializer.Serializer;
import com.qfpay.clientstat.utils.Logger;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * 事件磁盘写入器
 * <p>
 * Created by joye on 2017/9/20.
 */

public class EventFileWriter implements EventWriter {
    private static final String TAG = "EventFileWriter";
    private EventFileProvider eventFileProvider;
    private File eventFile;
    private Serializer serializer;

    public EventFileWriter(Context context, StatProxy statProxy) {
        this.eventFileProvider = new DefaultEventFileProvider(context, statProxy.getStatConfig().getEventFilePath());
        this.serializer = statProxy.getStatConfig().getSerializer();
    }

    @Override
    public synchronized File writeEvent(Event event) throws IOException {
        if (eventFile == null) {
            eventFile = eventFileProvider.newEventFile();
        }
        String eventContent = serializer.serialize(event);
        byte[] bytes = eventContent.getBytes("UTF-8");
        FileOutputStream fileOutputStream = new FileOutputStream(eventFile, true);
        fileOutputStream.write(bytes, 0, bytes.length);
        fileOutputStream.close();
        return eventFile;
    }

    @Override
    public void newFile() throws IOException {
        if (eventFileProvider != null) {
            this.eventFile = eventFileProvider.newEventFile();
        }
    }

    @Override
    public void deleteFile(File file) throws IOException {
        if (eventFileProvider != null) {
            eventFileProvider.delEventFile(file);
        }
    }

    @Override
    public EventFileProvider getEventFileProvider() {
        return eventFileProvider;
    }
}
