package com.qfpay.clientstat.internal;

import com.google.gson.reflect.TypeToken;
import com.qfpay.clientstat.ClientStat;
import com.qfpay.clientstat.utils.FileUtil;
import com.qfpay.clientstat.utils.Logger;

import java.io.File;
import java.io.IOException;
import java.util.List;

import in.joye.urlconnection.UrlConnectionWrapper;
import in.joye.urlconnection.client.Call;
import in.joye.urlconnection.client.Callback;
import in.joye.urlconnection.client.Request;
import in.joye.urlconnection.client.RequestBuilder;
import in.joye.urlconnection.client.RequestType;
import in.joye.urlconnection.client.ResponseWrapper;
import in.joye.urlconnection.http.HttpRequestMethod;
import in.joye.urlconnection.mime.TypedFile;

/**
 * 统计文件上传器
 * <p>
 * Created by joye on 2017/9/20.
 */

public class EventFileUploader {
    private static final String TAG = "EventFileUploader";

    /**
     * 同步上传文件
     *
     * @param fileList 文件列表
     * @return 是否全部上传成功
     */
    public static boolean uploadEventFileSync(List<File> fileList) {
        if (fileList != null) {
            UrlConnectionWrapper urlConnectionWrapper = UrlConnectionWrapper.getInstance();
            RequestBuilder requestBuilder = new RequestBuilder(ClientStat.getStatProxy().getStatConfig().getServerUrl(), HttpRequestMethod.POST, RequestType.MULTIPART);
//            requestBuilder.addHeader("Content-Encoding", "gzip");
//            requestBuilder.addHeader("Accept-Encoding", "gzip");
            boolean allUploadSuc = true;
            for (File file : fileList) {
                TypedFile typedFile = new TypedFile("file", file);
                requestBuilder.addMultiPart("stat", typedFile);
                Request uploadRequest = requestBuilder.build();
                Call<UploadResult> call = urlConnectionWrapper.create(uploadRequest, new TypeToken<UploadResult>() {
                }.getType());
                try {
                    ResponseWrapper<UploadResult> resultResponseWrapper = call.execute();
                    if (resultResponseWrapper != null) {
                        UploadResult uploadResult = resultResponseWrapper.getResponseBody();
                        if (uploadResult != null && uploadResult.isUploadSuccess()) {
                            Logger.d(TAG, "upload file {'%s'} success, the result is %s.", file.getAbsoluteFile(), uploadResult);
                            FileUtil.delFile(file);
                        } else {
                            allUploadSuc = false;
                        }
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return allUploadSuc;
        }

        return false;
    }

    public static void uploadEventFileAsync(File file, Callback<UploadResult> callback) {
        if (file == null || !file.exists()) {
            Logger.e(TAG, "param 'file' is null or not exist.");
            return;
        }
        if (callback == null) {
            Logger.e(TAG, "param 'callback' must not be null.");
            return;
        }
        UrlConnectionWrapper urlConnectionWrapper = UrlConnectionWrapper.getInstance();
        RequestBuilder requestBuilder = new RequestBuilder(ClientStat.getStatProxy().getStatConfig().getServerUrl(), HttpRequestMethod.POST, RequestType.MULTIPART);
//            requestBuilder.addHeader("Content-Encoding", "gzip");
//            requestBuilder.addHeader("Accept-Encoding", "gzip");
        TypedFile typedFile = new TypedFile("file", file);
        requestBuilder.addMultiPart("stat", typedFile);
        Request uploadRequest = requestBuilder.build();
        Call<UploadResult> call = urlConnectionWrapper.create(uploadRequest, new TypeToken<UploadResult>() {
        }.getType());
        call.enqueue(callback);
    }

}
