package com.qfpay.clientstat.internal;

import android.support.annotation.NonNull;

import java.io.File;
import java.net.URI;

/**
 * 自定义统计事件文件
 * <p>
 * 包含当前文件行数，无需遍历
 * <p>
 * Created by joye on 2017/9/26.
 */

public class EventFile extends File {
    private int lineNumber = 0;

    public EventFile(@NonNull String pathname) {
        super(pathname);
    }

    public EventFile(String parent, @NonNull String child) {
        super(parent, child);
    }

    public EventFile(File parent, @NonNull String child) {
        super(parent, child);
    }

    public EventFile(@NonNull URI uri) {
        super(uri);
    }

    public synchronized void addLineNum() {
        this.lineNumber++;
    }

    public synchronized int getLineNum() {
        return lineNumber;
    }
}
