package com.qfpay.clientstat.event;

import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;

import com.qfpay.clientstat.config.StatConfig;
import com.qfpay.clientstat.utils.TelephonyUtils;

/**
 * 设备相关信息
 */
public class Device implements Parcelable {

    /**
     * Default constructor
     *
     * @param context 上下文
     */
    public Device(Context context) {
        this.app_id = TelephonyUtils.getPackageName(context);
        this.net_env = TelephonyUtils.getCurrentNetworkType(context);
        this.app_name = TelephonyUtils.getApplicationName(context);
        this.app_ver = TelephonyUtils.getVersionName(context);
        this.operator = TelephonyUtils.getSimOperator(context);
        this.udid = TelephonyUtils.getUDID(context);
        this.mac = TelephonyUtils.getMacAddress(context);
        this.imei = TelephonyUtils.getImei(context);
        this.device = Build.MODEL;
        this.os_ver = Build.VERSION.RELEASE;
        this.os = "Android";
        this.user_id = StatConfig.getInstance().getUserId();
    }

    /**
     * 应用标识，在Android 中为包名
     */
    private String app_id;

    /**
     * 应用名称
     */
    private String app_name;

    /**
     * 应用版本
     */
    private String app_ver;

    /**
     * 设备名称
     */
    private String device;

    /**
     * 国际移动设备标识码
     */
    private String imei;

    /**
     * 经纬度，以逗号分隔。例：114.934555,39.112993
     */
    private String lnglat;

    /**
     * 设备网卡mac地址
     */
    private String mac;

    /**
     * 网络环境，例WIFI、4G
     */
    private String net_env;

    /**
     * SIM卡运营商信息，例中国移动
     */
    private String operator;

    /**
     * 设备操作系统，例Android
     */
    private String os;

    /**
     * 设备操作系统版本，例4.4.4
     */
    private String os_ver;

    /**
     * 64位设备序列号，重装系统后会变化
     */
    private String udid;

    /**
     * 用户信息标识
     */
    private String user_id;

    /**
     * 客户端时间与服务端时间差
     */
    private int time_diff;

    @Override
    public String toString() {
        return "Device{" +
                "app_id='" + app_id + '\'' +
                ", app_name='" + app_name + '\'' +
                ", app_ver='" + app_ver + '\'' +
                ", device='" + device + '\'' +
                ", imei='" + imei + '\'' +
                ", lnglat='" + lnglat + '\'' +
                ", mac='" + mac + '\'' +
                ", net_env='" + net_env + '\'' +
                ", operator='" + operator + '\'' +
                ", os='" + os + '\'' +
                ", os_ver='" + os_ver + '\'' +
                ", udid='" + udid + '\'' +
                ", user_id='" + user_id + '\'' +
                ", time_diff='" + time_diff + '\'' +
                '}';
    }

    public String getApp_id() {
        return app_id;
    }

    public void setApp_id(String app_id) {
        this.app_id = app_id;
    }

    public String getApp_name() {
        return app_name;
    }

    public void setApp_name(String app_name) {
        this.app_name = app_name;
    }

    public String getApp_ver() {
        return app_ver;
    }

    public void setApp_ver(String app_ver) {
        this.app_ver = app_ver;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getLnglat() {
        return lnglat;
    }

    public void setLnglat(String lnglat) {
        this.lnglat = lnglat;
    }

    public String getMac() {
        return mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getNet_env() {
        return net_env;
    }

    public void setNet_env(String net_env) {
        this.net_env = net_env;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getOs_ver() {
        return os_ver;
    }

    public void setOs_ver(String os_ver) {
        this.os_ver = os_ver;
    }

    public String getUdid() {
        return udid;
    }

    public void setUdid(String udid) {
        this.udid = udid;
    }

    public String getUser_id() {
        return user_id;
    }

    public void setUser_id(String user_id) {
        this.user_id = user_id;
    }

    public int getTime_diff() {
        return time_diff;
    }

    public void setTime_diff(int time_diff) {
        this.time_diff = time_diff;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.app_id);
        dest.writeString(this.app_name);
        dest.writeString(this.app_ver);
        dest.writeString(this.device);
        dest.writeString(this.imei);
        dest.writeString(this.lnglat);
        dest.writeString(this.mac);
        dest.writeString(this.net_env);
        dest.writeString(this.operator);
        dest.writeString(this.os);
        dest.writeString(this.os_ver);
        dest.writeString(this.udid);
        dest.writeString(this.user_id);
        dest.writeInt(this.time_diff);
    }

    protected Device(Parcel in) {
        this.app_id = in.readString();
        this.app_name = in.readString();
        this.app_ver = in.readString();
        this.device = in.readString();
        this.imei = in.readString();
        this.lnglat = in.readString();
        this.mac = in.readString();
        this.net_env = in.readString();
        this.operator = in.readString();
        this.os = in.readString();
        this.os_ver = in.readString();
        this.udid = in.readString();
        this.user_id = in.readString();
        this.time_diff = in.readInt();
    }

    public static final Parcelable.Creator<Device> CREATOR = new Parcelable.Creator<Device>() {
        @Override
        public Device createFromParcel(Parcel source) {
            return new Device(source);
        }

        @Override
        public Device[] newArray(int size) {
            return new Device[size];
        }
    };
}