package com.qfpay.clientstat.config;

import com.qfpay.clientstat.serializer.DefaultSerializer;
import com.qfpay.clientstat.serializer.Serializer;
import com.qfpay.clientstat.upload.QuantityUpload;
import com.qfpay.clientstat.upload.UploadStrategy;
import com.qfpay.clientstat.utils.TelephonyUtils;

import java.util.*;

/**
 * 统计配置类（单例）
 */
public class StatConfig {
    private static final StatConfig mInstance = new StatConfig();

    private static final String DEFAULT_UPLOAD_URL = "https://o.qfpay.com/clientlog/v1";

    private static final int DEFAULT_MAX_LOG_COUNT = 10;

    private static final int DEFAULT_CONNECT_TIMEOUT = 20000;

    private static final int DEFAULT_READ_TIMEOUT = 20000;

    private static final String DEFAULT_LOG_DIR = "/clientstat/log/";

    /**
     * Default constructor
     */
    private StatConfig() {
    }

    /**
     * 文件存储路径
     * 此路径为相对路径，如/app-name/stat，则最终路径为/data/data/app-package/files/app-name/stat 或 /mnt/sdcard/app-name/stat
     */
    private String eventFilePath;

    /**
     * 服务端地址
     */
    private String serverUrl;

    /**
     * 上传策略
     */
    private List<UploadStrategy> uploadStrategies;

    /**
     * 数据序列化器
     */
    private Serializer serializer;

    /**
     * 会话时长，即定义应用进入后台后多久，再回到前台重新计算一次会话
     */
    private long sessionDuration;

    /**
     * 经纬度
     */
    private String lnglat;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 服务端时间差
     */
    private int timeDiff;

    /**
     * 服务端连接超时时间
     */
    private int serverConnectTimeout;

    /**
     * 服务端读写时间
     */
    private int serverRWTimeout;

    /**
     * 私有构造函数
     */
    private void StatisConfig() {
    }

    /**
     * 获取配置实例
     *
     * @return StatConfig
     */
    public static StatConfig getInstance() {
        return mInstance;
    }

    /**
     * 设置服务器地址
     *
     * @param url http://www.****.com/***
     */
    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    /**
     * 设置上传策略
     *
     * @param strategies 策略列表
     */
    public void setUploadStrategies(List<UploadStrategy> strategies) {
        this.uploadStrategies = strategies;
    }

    /**
     * 设置序列化器
     *
     * @param serializer 序列化器
     */
    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    /**
     * 设置会话时长
     *
     * @param duration 时长
     */
    public void setSessionDuration(int duration) {
        this.sessionDuration = duration;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public int getTimeDiff() {
        return timeDiff;
    }

    public void setTimeDiff(int timeDiff) {
        this.timeDiff = timeDiff;
    }

    public String getEventFilePath() {
        if (eventFilePath == null) {
            eventFilePath = DEFAULT_LOG_DIR;
        }
        return eventFilePath;
    }

    public void setEventFilePath(String eventFilePath) {
        this.eventFilePath = eventFilePath;
    }

    public String getServerUrl() {
        if (serverUrl == null) {
            serverUrl = DEFAULT_UPLOAD_URL;
        }
        return serverUrl;
    }

    public List<UploadStrategy> getUploadStrategies() {
        if (uploadStrategies == null || uploadStrategies.size() == 0) {
            uploadStrategies = new ArrayList<>(5);
            UploadStrategy quantityUs = new QuantityUpload(DEFAULT_MAX_LOG_COUNT);
            uploadStrategies.add(quantityUs);
        }
        return uploadStrategies;
    }

    public Serializer getSerializer() {
        if (serializer == null) {
            serializer = new DefaultSerializer();
        }
        return serializer;
    }

    public long getSessionDuration() {
        return sessionDuration;
    }

    public String getLnglat() {
        return lnglat;
    }

    public int getServerConnectTimeout() {
        if (serverConnectTimeout == 0) {
            serverConnectTimeout = DEFAULT_CONNECT_TIMEOUT;
        }
        return serverConnectTimeout;
    }

    public int getServerRWTimeout() {
        if (serverRWTimeout == 0) {
            serverRWTimeout = DEFAULT_READ_TIMEOUT;
        }
        return serverRWTimeout;
    }

    public void setSessionDuration(long sessionDuration) {
        this.sessionDuration = sessionDuration;
    }

    public void setLnglat(String lnglat) {
        this.lnglat = lnglat;
    }

    public void setServerConnectTimeout(int serverConnectTimeout) {
        this.serverConnectTimeout = serverConnectTimeout;
    }

    public void setServerRWTimeout(int serverRWTimeout) {
        this.serverRWTimeout = serverRWTimeout;
    }
}