/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.Common;

import com.qcloud.Common.Sign;
import com.qcloud.Utilities.MD5;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request {
    protected static String requestUrl = "";
    protected static String rawResponse = "";
    protected static String version = "SDK_JAVA_1.3";
    protected static int timeOut = 1000;

    public static String getRequestUrl() {
        return requestUrl;
    }

    public static String getRawResponse() {
        return rawResponse;
    }

    public static String generateUrl(TreeMap<String, Object> params, String secretId, String secretKey, String requestMethod, String requestHost, String requestPath) {
        if (!params.containsKey("SecretId")) {
            params.put("SecretId", secretId);
        }
        if (!params.containsKey("Nonce")) {
            params.put("Nonce", new Random().nextInt(Integer.MAX_VALUE));
        }
        if (!params.containsKey("Timestamp")) {
            params.put("Timestamp", System.currentTimeMillis() / 1000L);
        }
        params.put("RequestClient", version);
        String plainText = Sign.makeSignPlainText(params, requestMethod, requestHost, requestPath);
        String signatureMethod = "HmacSHA1";
        if (params.containsKey("SignatureMethod") && params.get("SignatureMethod").toString().equals("HmacSHA256")) {
            signatureMethod = "HmacSHA256";
        }
        try {
            params.put("Signature", Sign.sign(plainText, secretKey, signatureMethod));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (params.get("Action").toString().equals("MultipartUploadVodFile")) {
            String url = "http://" + requestHost + requestPath;
            url = url + Sign.buildParamStr1(params, requestMethod);
            return url;
        }
        String url = "https://" + requestHost + requestPath;
        if (requestMethod.equals("GET")) {
            url = url + Sign.buildParamStr1(params, requestMethod);
        }
        return url;
    }

    public static String send(TreeMap<String, Object> params, String secretId, String secretKey, String requestMethod, String requestHost, String requestPath, String fileName) {
        if (!params.containsKey("SecretId")) {
            params.put("SecretId", secretId);
        }
        if (!params.containsKey("Nonce")) {
            params.put("Nonce", new Random().nextInt(Integer.MAX_VALUE));
        }
        if (!params.containsKey("Timestamp")) {
            params.put("Timestamp", System.currentTimeMillis() / 1000L);
        }
        params.put("RequestClient", version);
        params.remove("Signature");
        String plainText = Sign.makeSignPlainText(params, requestMethod, requestHost, requestPath);
        String signatureMethod = "HmacSHA1";
        if (params.containsKey("SignatureMethod") && params.get("SignatureMethod").toString().equals("HmacSHA256")) {
            signatureMethod = "HmacSHA256";
        }
        try {
            params.put("Signature", Sign.sign(plainText, secretKey, signatureMethod));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (params.get("Action").toString().equals("MultipartUploadVodFile")) {
            String url = "http://" + requestHost + requestPath;
            return Request.sendMultipartUploadVodFileRequest(url, params, requestMethod, fileName);
        }
        String url = "https://" + requestHost + requestPath;
        return Request.sendRequest(url, params, requestMethod, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendRequest(String url, Map<String, Object> requestParams, String requestMethod, String fileName) {
        String result = "";
        BufferedReader in = null;
        String paramStr = "";
        for (String key : requestParams.keySet()) {
            if (!paramStr.isEmpty()) {
                paramStr = paramStr + '&';
            }
            try {
                paramStr = paramStr + key + '=' + URLEncoder.encode(requestParams.get(key).toString(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                result = "{\"code\":-2300,\"location\":\"com.qcloud.Common.Request:129\",\"message\":\"api sdk throw exception! " + e.toString() + "\"}";
            }
        }
        try {
            String line;
            if (requestMethod.equals("GET")) {
                url = url.indexOf(63) > 0 ? url + '&' + paramStr : url + '?' + paramStr;
            }
            requestUrl = url;
            String BOUNDARY = "---------------------------" + MD5.stringToMD5(String.valueOf(System.currentTimeMillis())).substring(0, 15);
            URL realUrl = new URL(url);
            URLConnection connection = null;
            if (url.toLowerCase().startsWith("https")) {
                HttpsURLConnection httpsConn = (HttpsURLConnection)realUrl.openConnection();
                connection = httpsConn;
            } else {
                connection = realUrl.openConnection();
            }
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.setConnectTimeout(timeOut);
            if (requestMethod.equals("POST")) {
                ((HttpURLConnection)connection).setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                StringBuffer strBuf = new StringBuffer();
                for (String key : requestParams.keySet()) {
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"" + key + "\"\r\n\r\n");
                    strBuf.append(requestParams.get(key));
                }
                ((OutputStream)out).write(strBuf.toString().getBytes());
                if (fileName != null) {
                    File file = new File(fileName);
                    String filename = file.getName();
                    String contentType = URLConnection.getFileNameMap().getContentTypeFor(fileName);
                    strBuf = new StringBuffer();
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"entityFile\"; filename=\"" + filename + "\"\r\n");
                    strBuf.append("Content-Type:" + contentType + "\r\n\r\n");
                    ((OutputStream)out).write(strBuf.toString().getBytes());
                    DataInputStream ins = new DataInputStream(new FileInputStream(file));
                    int bytes = 0;
                    byte[] bufferOut = new byte[1024];
                    while ((bytes = ins.read(bufferOut)) != -1) {
                        ((OutputStream)out).write(bufferOut, 0, bytes);
                    }
                    ins.close();
                }
                byte[] endData = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
                ((OutputStream)out).write(endData);
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            }
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            result = "{\"code\":-2700,\"location\":\"com.qcloud.Common.Request:225\",\"message\":\"api sdk throw exception! " + e.toString() + "\"}";
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                result = "{\"code\":-2800,\"location\":\"com.qcloud.Common.Request:234\",\"message\":\"api sdk throw exception! " + e2.toString() + "\"}";
            }
        }
        rawResponse = result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendMultipartUploadVodFileRequest(String url, Map<String, Object> requestParams, String requestMethod, String fileName) {
        String result = "";
        BufferedReader in = null;
        String paramStr = "";
        for (String key : requestParams.keySet()) {
            if (!paramStr.isEmpty()) {
                paramStr = paramStr + '&';
            }
            try {
                paramStr = paramStr + key + '=' + URLEncoder.encode(requestParams.get(key).toString(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                result = "{\"code\":-2400,\"location\":\"com.qcloud.Common.Request:263\",\"message\":\"api sdk throw exception! " + e.toString() + "\"}";
            }
        }
        try {
            String line;
            url = url.indexOf(63) > 0 ? url + '&' + paramStr : url + '?' + paramStr;
            System.out.println(url);
            requestUrl = url;
            URL realUrl = new URL(url);
            URLConnection connection = null;
            if (url.toLowerCase().startsWith("https")) {
                HttpsURLConnection httpsConn = (HttpsURLConnection)realUrl.openConnection();
                httpsConn.setHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
                connection = httpsConn;
            } else {
                connection = realUrl.openConnection();
            }
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setConnectTimeout(timeOut);
            File file = new File(fileName);
            long file_length = (Long)requestParams.get("fileSize");
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            DataInputStream ins = new DataInputStream(new FileInputStream(file));
            int offset = (Integer)requestParams.get("offset");
            int dataSize = (Integer)requestParams.get("dataSize");
            if ((long)offset >= file_length) {
                String string = "{\"code\":-3001,\"location\":\"com.qcloud.Common.Request:303\",\"message\":\"api sdk throw exception! offset larger than the size of file\"}";
                return string;
            }
            int skipBytes = ins.skipBytes(offset);
            int remainder = dataSize % 1024;
            int bytes = 0;
            byte[] bufferOut = new byte[1024];
            byte[] bufferOut2 = new byte[remainder];
            for (int page = dataSize / 1024; page != 0; --page) {
                bytes = ins.read(bufferOut);
                if (bytes == -1) continue;
                ((OutputStream)out).write(bufferOut, 0, bytes);
            }
            bytes = ins.read(bufferOut2);
            if (bytes != -1) {
                ((OutputStream)out).write(bufferOut2, 0, bytes);
            }
            ins.close();
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            connection.connect();
            try {
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            }
            catch (Exception e) {
                result = "{\"code\":-3002,\"location\":\"com.qcloud.Common.Request:331\",\"message\":\"api sdk throw exception! protocol doesn't support input or the character Encoding is not supported.details: " + e.toString() + "\"}";
                if (in != null) {
                    in.close();
                }
                rawResponse = result;
                String string = result;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e2) {
                    result = "{\"code\":-3003,\"location\":\"com.qcloud.Common.Request:354\",\"message\":\"api sdk throw exception! " + e2.toString() + "\"}";
                }
                return string;
            }
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            result = "{\"code\":-3000,\"location\":\"com.qcloud.Common.Request:345\",\"message\":\"api sdk throw exception! " + e.toString() + "\"}";
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                result = "{\"code\":-3003,\"location\":\"com.qcloud.Common.Request:354\",\"message\":\"api sdk throw exception! " + e2.toString() + "\"}";
            }
        }
        rawResponse = result;
        return result;
    }
}

